<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('test'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_test'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('hospital/diagnostic/left-side'); ?>
        <!-- col-xl-9 -->
        <div class="col-lg-9">
            <div class="card">

                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'hospital', 'diagnostic')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-h-square font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('test'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'hospital', 'diagnostic')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('hospital/diagnostic/test'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('test'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('hospital/diagnostic/edit_test'), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select" name="department_id" id="department_id" required onchange="get_group(this.value)">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($test->department_id) && $test->department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="group_id"><?php echo $this->lang->line('group'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select" name="group_id" id="group_id">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($groups as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($test->group_id) && $test->group_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="specimen"><?php echo $this->lang->line('specimen'); ?></label>
                            <select class="form-control custom-select" name="specimen" id="specimen">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $specimens = get_specimen(); ?>
                                <?php foreach ($specimens as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($test->specimen) && $test->specimen == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="name"><?php echo $this->lang->line('test'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($test->name) ?  $test->name : ''; ?>" placeholder="<?php echo $this->lang->line('test'); ?> <?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="code"><?php echo $this->lang->line('code'); ?></label>
                            <input type="text" class="form-control" name="code" id="code" value="<?php echo isset($test->code) ?  $test->code : get_custom_id('diagnostic_tests', 'C10'); ?>" placeholder="<?php echo $this->lang->line('code'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="room_no"><?php echo $this->lang->line('room_no'); ?></label>
                            <input type="number" class="form-control" name="room_no" id="room_no" value="<?php echo isset($test->room_no) ?  $test->room_no : ''; ?>" placeholder="<?php echo $this->lang->line('room_no'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="rate"><?php echo $this->lang->line('rate'); ?></label>
                            <input type="text" class="form-control" name="rate" id="rate" value="<?php echo isset($test->rate) ?  $test->rate : ''; ?>" placeholder="<?php echo $this->lang->line('rate'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="rate" class="form-text text-muted">
                                <?php echo form_error('rate'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="special_discount"><?php echo $this->lang->line('special'); ?> <?php echo $this->lang->line('discount'); ?></label>
                            <input type="text" class="form-control" name="special_discount" id="special_discount" value="<?php echo isset($test->special_discount) ?  $test->special_discount : ''; ?>" placeholder="<?php echo $this->lang->line('special'); ?> <?php echo $this->lang->line('discount'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="mbbs"><?php echo $this->lang->line('mbbs'); ?></label>
                            <input type="text" class="form-control" name="mbbs" id="mbbs" value="<?php echo isset($test->mbbs) ?  $test->mbbs : ''; ?>" placeholder="<?php echo $this->lang->line('mbbs'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="vd"><?php echo $this->lang->line('vd'); ?></label>
                            <input type="text" class="form-control" name="vd" id="vd" value="<?php echo isset($test->vd) ?  $test->vd : ''; ?>" placeholder="<?php echo $this->lang->line('vd'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="emp"><?php echo $this->lang->line('emp'); ?></label>
                            <input type="text" class="form-control" name="emp" id="emp" value="<?php echo isset($test->emp) ?  $test->emp : ''; ?>" placeholder="<?php echo $this->lang->line('emp'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="corporate"><?php echo $this->lang->line('corporate'); ?></label>
                            <input type="text" class="form-control" name="corporate" id="corporate" value="<?php echo isset($test->corporate) ?  $test->corporate : ''; ?>" placeholder="<?php echo $this->lang->line('corporate'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="sort_by"><?php echo $this->lang->line('sort_by'); ?></label>
                            <input type="number" class="form-control" name="sort_by" id="sort_by" value="<?php echo isset($test->sort_by) ?  $test->sort_by : ''; ?>" placeholder="<?php echo $this->lang->line('sort_by'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="tube_id"><?php echo $this->lang->line('tube'); ?></label>
                            <select class="form-control custom-select" name="tube_id" id="tube_id">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($tubes as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($test->tube_id) && $test->tube_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="needle_id"><?php echo $this->lang->line('needle'); ?></label>
                            <select class="form-control custom-select" name="needle_id" id="needle_id">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($tubes as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($test->needle_id) && $test->needle_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" <?php echo $test->status ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('test'); ?> <?php echo $this->lang->line('note'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="note" aria-label="<?php echo $this->lang->line('test'); ?> <?php echo $this->lang->line('note'); ?>"><?php echo isset($test->note) ?  $test->note : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $test->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('hospital/diagnostic/test'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<script>
    function get_group(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_diagnostic_group'); ?>",
            data: {
                department_id: department_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#group_id').html(response);
                }
            }
        });
    };
</script>