<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Diagnostic_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_department_list($limit, $offset, $search, $count) {
        $this->db->select('D.*');
        $this->db->from('diagnostic_departments AS D');
        if ($search) {
            $this->db->like('D.name', $search);
            $this->db->or_like('D.bn_name', $search);
            $this->db->or_like('D.note', $search);
        }
        $this->db->order_by('D.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_department_name($name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('diagnostic_departments')->num_rows();
    }

    public function get_group_list($limit, $offset, $search, $count) {
        $this->db->select('G.*, D.name as department');
        $this->db->from('diagnostic_groups AS G');
        $this->db->join('diagnostic_departments AS D', 'D.id = G.department_id', 'left');
        if ($search) {
            $this->db->like('G.name', $search);
            $this->db->or_like('G.bn_name', $search);
            $this->db->or_like('G.note', $search);
        }
        $this->db->order_by('G.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_group_name($department_id, $name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('department_id', $department_id);
        $this->db->where('name', $name);
        return $this->db->get('diagnostic_groups')->num_rows();
    }

    public function get_test_list($limit, $offset, $department_id, $group_id, $search, $count) {
        $this->db->select('T.*, D.name as department, DT.name as tube, N.name as needle');
        $this->db->from('diagnostic_tests AS T');
        $this->db->join('diagnostic_departments AS D', 'D.id = T.department_id', 'left');
        $this->db->join('diagnostic_groups AS G', 'G.id = T.group_id', 'left');
        $this->db->join('diagnostic_tubes AS DT', 'DT.id = T.tube_id', 'left');
        $this->db->join('diagnostic_tubes AS N', 'N.id = T.needle_id', 'left');
        if ($search) {
            $this->db->like('T.name', $search, 'both');
            $this->db->or_like('T.code', $search);
            $this->db->or_like('T.room_no', $search);
            $this->db->or_like('T.rate', $search);
            $this->db->or_like('T.note', $search, 'both');
            $this->db->or_like('D.name', $search, 'both');
            $this->db->or_like('G.name', $search, 'both');
        }
        if ($department_id) {
            $this->db->where('T.department_id', $department_id);
        }
        if ($group_id) {
            $this->db->where('T.group_id', $group_id);
        }
        $this->db->order_by('T.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_test($id) {
        $this->db->select('T.*, D.name as department, G.name as group, DT.name as tube, N.name as needle, C.name as created_by, M.name as modified_by');
        $this->db->from('diagnostic_tests AS T');
        $this->db->join('diagnostic_departments AS D', 'D.id = T.department_id', 'left');
        $this->db->join('diagnostic_groups AS G', 'G.id = T.group_id', 'left');
        $this->db->join('diagnostic_tubes AS DT', 'DT.id = T.tube_id', 'left');
        $this->db->join('diagnostic_tubes AS N', 'N.id = T.needle_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = T.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = T.modified_by', 'left');
        $this->db->where('T.id', $id);
        return $this->db->get()->row();
    }

    function duplicate_check_test_name($department_id, $name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('department_id', $department_id);
        $this->db->where('name', $name);
        return $this->db->get('diagnostic_tests')->num_rows();
    }

    function total_rate() {
        $this->db->select('T.*, SUM(T.rate) as total_rate, SUM(T.mbbs) as total_mbbs, , SUM(T.vd) as total_vd, , SUM(T.emp) as total_emp, , SUM(T.corporate) as total_corporate');
        $this->db->from('diagnostic_tests AS T');
        $this->db->where('T.status', 1);
        return $this->db->get()->row();
    }

    public function get_test_price_update_list($department_id, $group_id) {
        $this->db->select('T.*, D.name as department, G.name as group');
        $this->db->from('diagnostic_tests AS T');
        $this->db->join('diagnostic_departments AS D', 'D.id = T.department_id', 'left');
        $this->db->join('diagnostic_groups AS G', 'G.id = T.group_id', 'left');
        if ($department_id) {
            $this->db->where('T.department_id', $department_id);
        }
        if ($group_id) {
            $this->db->where('T.group_id', $group_id);
        }
        $this->db->order_by('T.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_tube_list($limit, $offset, $search, $count) {
        $this->db->select('T.*');
        $this->db->from('diagnostic_tubes AS T');
        if ($search) {
            $this->db->like('T.name', $search);
            $this->db->or_like('T.type', $search);
        }
        $this->db->order_by('T.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_tube($id) {
        $this->db->select('T.*, C.name as created_by, M.name as modified_by');
        $this->db->from('diagnostic_tubes AS T');
        $this->db->join('employees AS C', 'C.user_id = T.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = T.modified_by', 'left');
        $this->db->where('T.id', $id);
        return $this->db->get()->row();
    }
}
