<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('visitor'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_visitor'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
       	<div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('frontoffice/visitor'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="search"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($create_date) ?  $create_date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="land">Profession</label>
                             <select class="form-control custom-select" name="profession" id="profession">
                               <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('profession'); ?></option>
                               <option value="ডাক্তার" <?php echo isset($profession) && $profession == 'ডাক্তার' ? 'selected="selected"' : ""; ?>>ডাক্তার</option>
                               <option value="ধাত্রী" <?php echo isset($profession) && $profession == 'ধাত্রী' ? 'selected="selected"' : ""; ?>>ধাত্রী</option>
                               <option value="মেম্বর" <?php echo isset($profession) && $profession == 'মেম্বর' ? 'selected="selected"' : ""; ?>>মেম্বর</option>
                               <option value="চেয়ারম্যান" <?php echo isset($profession) && $profession == 'চেয়ারম্যান' ? 'selected="selected"' : ""; ?>>চেয়ারম্যান</option>
                               <option value="ইমাম" <?php echo isset($profession) && $profession == 'ইমাম' ? 'selected="selected"' : ""; ?>>ইমাম</option>
                               <option value="মুয়াজ্জিন" <?php echo isset($profession) && $profession == 'মুয়াজ্জিন' ? 'selected="selected"' : ""; ?>>মুয়াজ্জিন</option>
                               <option value="শিক্ষক" <?php echo isset($profession) && $profession == 'শিক্ষক' ? 'selected="selected"' : ""; ?>>শিক্ষক</option>
                               <option value="কৃষক" <?php echo isset($profession) && $profession == 'কৃষক' ? 'selected="selected"' : ""; ?>>কৃষক</option>
                               <option value="মৎস্যজীবী" <?php echo isset($profession) && $profession == 'মৎস্যজীবী' ? 'selected="selected"' : ""; ?>>মৎস্যজীবী</option>
                               <option value="সরকারী চাকুরিজীবী" <?php echo isset($profession) && $profession == 'সরকারী চাকুরিজীবী' ? 'selected="selected"' : ""; ?>>সরকারী চাকুরিজীবী</option>
                               <option value="কোম্পানি চাকুরিজীবী" <?php echo isset($profession) && $profession == 'কোম্পানি চাকুরিজীবী' ? 'selected="selected"' : ""; ?>>কোম্পানি চাকুরিজীবী</option>
                               <option value="ব্লাড ফাউন্ডেশন" <?php echo isset($profession) && $profession == 'ব্লাড ফাউন্ডেশন' ? 'selected="selected"' : ""; ?>>ব্লাড ফাউন্ডেশন</option>
                               <option value="সাস্থ্য কর্মী" <?php echo isset($profession) && $profession == 'সাস্থ্য কর্মী' ? 'selected="selected"' : ""; ?>>সাস্থ্য কর্মী</option>
                               <option value="ব্যাবসায়ী" <?php echo isset($profession) && $profession == 'ব্যাবসায়ী' ? 'selected="selected"' : ""; ?>>ব্যাবসায়ী</option>
                               <option value="গৃহিনী" <?php echo isset($profession) && $profession == 'গৃহিনী' ? 'selected="selected"' : ""; ?>>গৃহিনী</option>
                               <option value="শিক্ষার্থী" <?php echo isset($profession) && $profession == 'শিক্ষার্থী' ? 'selected="selected"' : ""; ?>>শিক্ষার্থী</option>
                               <option value="অন্যান্য" <?php echo isset($profession) && $profession == 'অন্যান্য' ? 'selected="selected"' : ""; ?>>অন্যান্য</option>
                             </select>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="land">Pregnancy</label>
                             <select class="form-control custom-select" name="pregnancy" id="pregnancy">
                               <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('pregnancy'); ?></option>
                               <option value="yes" <?php echo isset($pregnancy) && $pregnancy == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                               <option value="no" <?php echo isset($pregnancy) && $pregnancy == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                             </select>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="land">Emergency Treatment</label>
                             <select class="form-control custom-select" name="treatment" id="treatment">
                               <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('treatment'); ?></option>
                               <option value="yes" <?php echo isset($treatment) && $treatment == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                               <option value="no" <?php echo isset($treatment) && $treatment == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                               <option value="মেডিসিন & কার্ডিওলজি বিশেষজ্ঞ" <?php echo isset($treatment) && $treatment == 'মেডিসিন & কার্ডিওলজি বিশেষজ্ঞ' ? 'selected="selected"' : ""; ?>>মেডিসিন & কার্ডিওলজি বিশেষজ্ঞ</option>
                               <option value="নিউরো মেডিসিন" <?php echo isset($treatment) && $treatment == 'নিউরো মেডিসিন' ? 'selected="selected"' : ""; ?>>নিউরো মেডিসিন</option>
                               <option value="অর্থোপেডিক সার্জারি" <?php echo isset($treatment) && $treatment == 'অর্থোপেডিক সার্জারি' ? 'selected="selected"' : ""; ?>>অর্থোপেডিক সার্জারি</option>
                               <option value="গাইনী" <?php echo isset($treatment) && $treatment == 'গাইনী' ? 'selected="selected"' : ""; ?>>গাইনী</option>
                               <option value="বক্ষব্যাধি" <?php echo isset($treatment) && $treatment == 'বক্ষব্যাধি' ? 'selected="selected"' : ""; ?>>বক্ষব্যাধি</option>
                               <option value="চর্ম যৌন এলার্জি" <?php echo isset($treatment) && $treatment == 'চর্ম যৌন এলার্জি' ? 'selected="selected"' : ""; ?>>চর্ম যৌন এলার্জি</option>
                               <option value="শিশু মেডিসিন" <?php echo isset($treatment) && $treatment == 'শিশু মেডিসিন' ? 'selected="selected"' : ""; ?>>শিশু মেডিসিন</option>
                               <option value="চক্ষু ও ফ্যাকো সার্জারি" <?php echo isset($treatment) && $treatment == 'চক্ষু ও ফ্যাকো সার্জারি' ? 'selected="selected"' : ""; ?>>চক্ষু ও ফ্যাকো সার্জারি</option>
                               <option value="নাক কান গলা" <?php echo isset($treatment) && $treatment == 'নাক কান গলা' ? 'selected="selected"' : ""; ?>>নাক কান গলা</option>
                               <option value="কিডনি ও ইউরোলজি" <?php echo isset($treatment) && $treatment == 'কিডনি ও ইউরোলজি' ? 'selected="selected"' : ""; ?>>কিডনি ও ইউরোলজি</option>
                               <option value="জেনারেল সার্জারি ও ল্যাপারোস্কোপিক সার্জারি" <?php echo isset($treatment) && $treatment == 'জেনারেল সার্জারি ও ল্যাপারোস্কোপিক সার্জারি' ? 'selected="selected"' : ""; ?>>জেনারেল সার্জারি ও ল্যাপারোস্কোপিক সার্জারি</option>
                               <option value="ডায়াবেটিস থাইরয়েড ও হরমোন" <?php echo isset($treatment) && $treatment == 'ডায়াবেটিস থাইরয়েড ও হরমোন' ? 'selected="selected"' : ""; ?>>ডায়াবেটিস থাইরয়েড ও হরমোন</option>
                               <option value="নেফ্রোলজি ও কিডনি" <?php echo isset($treatment) && $treatment == 'নেফ্রোলজি ও কিডনি' ? 'selected="selected"' : ""; ?>>নেফ্রোলজি ও কিডনি</option>
                               <option value="সনোলজিস্ট ও আল্ট্রাসাউন্ড" <?php echo isset($treatment) && $treatment == 'সনোলজিস্ট ও আল্ট্রাসাউন্ড' ? 'selected="selected"' : ""; ?>>সনোলজিস্ট ও আল্ট্রাসাউন্ড</option>
                             </select>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="land">Health Card</label>
                             <select class="form-control custom-select" name="card" id="card">
                               <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('card'); ?></option>
                               <option value="yes" <?php echo isset($card) && $card == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                               <option value="no" <?php echo isset($card) && $card == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                             </select>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="land">Health Package</label>
                             <select class="form-control custom-select" name="package" id="package">
                               <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('package'); ?></option>
                               <option value="yes" <?php echo isset($package) && $package == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                               <option value="no" <?php echo isset($package) && $package == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                               <option value="হার্টের চেকাআপ" <?php echo isset($package) && $package == 'হার্টের চেকাআপ' ? 'selected="selected"' : ""; ?>>হার্টের চেকাআপ</option>
                               <option value="ডায়াবেটিস চেকাআপ" <?php echo isset($package) && $package == 'ডায়াবেটিস চেকাআপ' ? 'selected="selected"' : ""; ?>>ডায়াবেটিস চেকাআপ</option>
                               <option value="কিডনি চেকআপ" <?php echo isset($package) && $package == 'কিডনি চেকআপ' ? 'selected="selected"' : ""; ?>>কিডনি চেকআপ</option>
                               <option value="প্রেগন্যান্সি চেকআপ" <?php echo isset($package) && $package == 'প্রেগন্যান্সি চেকআপ' ? 'selected="selected"' : ""; ?>>প্রেগন্যান্সি চেকআপ</option>
                               <option value="লিভার চেকআপ" <?php echo isset($package) && $package == 'লিভার চেকআপ' ? 'selected="selected"' : ""; ?>>লিভার চেকআপ</option>
                               <option value="থাইরয়েড চেকআপ" <?php echo isset($package) && $package == 'থাইরয়েড চেকআপ' ? 'selected="selected"' : ""; ?>>থাইরয়েড চেকআপ</option>
                               <option value="বিদেশগামীদের স্বাস্থ্য চেকআপ" <?php echo isset($package) && $package == 'বিদেশগামীদের স্বাস্থ্য চেকআপ' ? 'selected="selected"' : ""; ?>>বিদেশগামীদের স্বাস্থ্য চেকআপ</option>
                               <option value="ক্যান্সার চেকআপ(মহিলা)" <?php echo isset($package) && $package == 'ক্যান্সার চেকআপ(মহিলা)' ? 'selected="selected"' : ""; ?>>ক্যান্সার চেকআপ(মহিলা)</option>
                               <option value="ক্যান্সার চেকআপ(পুরুষ)" <?php echo isset($package) && $package == 'ক্যান্সার চেকআপ(পুরুষ)' ? 'selected="selected"' : ""; ?>>ক্যান্সার চেকআপ(পুরুষ)</option>
                               <option value="মহিলাদের স্বাস্থ্য চেকআপ" <?php echo isset($package) && $package == 'মহিলাদের স্বাস্থ্য চেকআপ' ? 'selected="selected"' : ""; ?>>মহিলাদের স্বাস্থ্য চেকআপ</option>
                               <option value="শিশুদের স্বাস্থ্য চেকআপ" <?php echo isset($package) && $package == 'শিশুদের স্বাস্থ্য চেকআপ' ? 'selected="selected"' : ""; ?>>শিশুদের স্বাস্থ্য চেকআপ</option>
                               <option value="মাদকাসক্তদের স্বাস্থ্য চেকআপ" <?php echo isset($package) && $package == 'মাদকাসক্তদের স্বাস্থ্য চেকআপ' ? 'selected="selected"' : ""; ?>>মাদকাসক্তদের স্বাস্থ্য চেকআপ</option>
                             </select>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="land">Land</label>
                             <select class="form-control custom-select" name="land" id="land">
                               <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('land'); ?></option>
                               <option value="yes" <?php echo isset($land) && $land == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                               <option value="no" <?php echo isset($land) && $land == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                             </select>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="land">Operation</label>
                             <select class="form-control custom-select" name="operation" id="operation">
                               <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('operation'); ?></option>
                               <option value="yes" <?php echo isset($operation) && $operation == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                               <option value="no" <?php echo isset($operation) && $operation == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                               <option value="নরমাল ডেলিভারি" <?php echo isset($operation) && $operation == 'নরমাল ডেলিভারি' ? 'selected="selected"' : ""; ?>>নরমাল ডেলিভারি</option>
                               <option value="সিজারিয়ান অপারেশন" <?php echo isset($operation) && $operation == 'সিজারিয়ান অপারেশন' ? 'selected="selected"' : ""; ?>>সিজারিয়ান অপারেশন</option>
                               <option value="এ্যাপেন্ডিসাইড" <?php echo isset($operation) && $operation == 'এ্যাপেন্ডিসাইড' ? 'selected="selected"' : ""; ?>>এ্যাপেন্ডিসাইড</option>
                               <option value="জরায়ু অপারেশন" <?php echo isset($operation) && $operation == 'জরায়ু অপারেশন' ? 'selected="selected"' : ""; ?>>জরায়ু অপারেশন</option>
                               <option value="হার্নিয়া অপারেশন" <?php echo isset($operation) && $operation == 'হার্নিয়া অপারেশন' ? 'selected="selected"' : ""; ?>>হার্নিয়া অপারেশন</option>
                               <option value="হাইড্রোসিন অপারেশন" <?php echo isset($operation) && $operation == 'হাইড্রোসিন অপারেশন' ? 'selected="selected"' : ""; ?>>হাইড্রোসিন অপারেশন</option>
                               <option value="পিত্তথলির পাথার" <?php echo isset($operation) && $operation == 'পিত্তথলির পাথার' ? 'selected="selected"' : ""; ?>>পিত্তথলির পাথার</option>
                               <option value="নাক-কান-গাল অপারেশন" <?php echo isset($operation) && $operation == 'নাক-কান-গাল অপারেশন' ? 'selected="selected"' : ""; ?>>নাক-কান-গাল অপারেশন</option>
                               <option value="হাড়ের অপারেশন" <?php echo isset($operation) && $operation == 'হাড়ের অপারেশন' ? 'selected="selected"' : ""; ?>>হাড়ের অপারেশন</option>
                               <option value="চোখের অপারেশন" <?php echo isset($operation) && $operation == 'চোখের অপারেশন' ? 'selected="selected"' : ""; ?>>চোখের অপারেশন</option>
                               <option value="পাইলস ফিষ্টুলা অপারেশন" <?php echo isset($operation) && $operation == 'পাইলস ফিষ্টুলা অপারেশন' ? 'selected="selected"' : ""; ?>>পাইলস ফিষ্টুলা অপারেশন</option>
                               <option value="টিউমার অপারেশন" <?php echo isset($operation) && $operation == 'টিউমার অপারেশন' ? 'selected="selected"' : ""; ?>>টিউমার অপারেশন</option>
                               <option value="অন্যান্য অপারেশন" <?php echo isset($operation) && $operation == 'অন্যান্য অপারেশন' ? 'selected="selected"' : ""; ?>>অন্যান্য অপারেশন</option>
                             </select>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="land">Lab Test</label>
                             <select class="form-control custom-select" name="test" id="test">
                               <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('test'); ?></option>
                               <option value="yes" <?php echo isset($test) && $test == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                               <option value="no" <?php echo isset($test) && $test == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                               <option value="প্যাথলজি" <?php echo isset($test) && $test == 'প্যাথলজি' ? 'selected="selected"' : ""; ?>>প্যাথলজি</option>
                               <option value="আল্ট্রাসনো" <?php echo isset($test) && $test == 'আল্ট্রাসনো' ? 'selected="selected"' : ""; ?>>আল্ট্রাসনো</option>
                               <option value="এক্স-রে" <?php echo isset($test) && $test == 'এক্স-রে' ? 'selected="selected"' : ""; ?>>এক্স-রে</option>
                               <option value="ইসিজি" <?php echo isset($test) && $test == 'ইসিজি' ? 'selected="selected"' : ""; ?>>ইসিজি</option>
                               <option value="ইকো" <?php echo isset($test) && $test == 'ইকো' ? 'selected="selected"' : ""; ?>>ইকো</option>
                             </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
        <!-- col-xl-8 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'frontoffice', 'visitor')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user font-30 mr-10"></i>
                            <?php echo $this->lang->line('visitor'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    
                    <?php if (has_permission(ADD, 'frontoffice', 'visitor')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('frontoffice/visitor/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('visitor'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th>Info. Name</th>
                                        <th><?php echo $this->lang->line('phone'); ?></th>
                                      	<th><?php echo $this->lang->line('address'); ?></th>
                                      	<th>Pregnancy</th>
                                      	<th>Emergency</th>
                                      	<th>Health Card</th>
                                      	<th>Package</th>
                                      	<th>Land</th>
                                      	<th>Operation</th>
                                      	<th>Lab Test</th>
                                        <th>Created By</th>
                                        <th><?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($visitors) && !empty($visitors)) { ?>
                                        <?php foreach ($visitors as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo $obj->name_info; ?></td>
                                                <td><?php echo $obj->phone; ?></td>
                                              	<td><?php echo $obj->bn_name_vl; ?>, <?php echo $obj->bn_name_un; ?>, <?php echo $obj->bn_name_up; ?></td>
                                              	<td><?php echo $obj->yes_no2; ?></td>
                                              	<td><?php echo $obj->yes_no3; ?></td>
                                              	<td><?php echo $obj->yes_no4; ?></td>
                                              	<td><?php echo $obj->yes_no5; ?></td>
                                              	<td><?php echo $obj->yes_no7; ?></td>
                                              	<td><?php echo $obj->yes_no8; ?></td>
                                              	<td><?php echo $obj->yes_no9; ?></td>
                                                <td><?php echo $obj->created_by; ?></td>
                                                <td><?php echo date($this->global_setting->date_format, strtotime($obj->date)); ?></td>
                                                <td>
                                                    <?php if (has_permission(EDIT, 'frontoffice', 'visitor')) { ?>
                                                        <a href="<?php echo site_url('frontoffice/visitor/edit/' . $obj->id); ?>" class="mr-25"> <i class="fa fa-pencil"></i> </a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'frontoffice', 'visitor')) { ?>
                                                        <a href="<?php echo site_url('frontoffice/visitor/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-red"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="8"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->
<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>