<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('visitor'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_visitor'); ?>
        </h4>
    </div>
    <!-- /Title -->


    <!-- Row -->
    <div class="row">
        
        <!-- col-xl-8 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'frontoffice', 'visitor')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('visitor'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'frontoffice', 'visitor')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('frontoffice/visitor'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('visitor'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <?php echo form_open_multipart(site_url('frontoffice/visitor/edit/' . $visitor->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="purpose_id">উপজেলা</label>
                            <select class="form-control custom-select select2" name="purpose_id" id="purpose_id" onchange="get_union(this.value)" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($visitor_purposes as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($visitor->purpose_id) && $visitor->purpose_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->bn_name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('purpose_id'); ?>
                            </small>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="union_id">ইউনিয়ন</label>
                            <select class="form-control custom-select select2" name="union_id" id="union_id" onchange="get_village(this.value)" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($unions as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($visitor->union_id) && $visitor->union_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->bn_name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('union_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="village_id">গ্রাম</label>
                            <select class="form-control custom-select select2" name="village_id" id="village_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($villages as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($visitor->village_id) && $visitor->village_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->bn_name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('village_id'); ?>
                            </small>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="profession">পেশা</label>
                            <select class="form-control custom-select" name="profession" id="profession">
                            <?php $professions = get_visitor_profession(); ?>
                                <?php foreach ($professions as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($visitor->profession) && $visitor->profession == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="name">অভিভাবকের নাম</label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($visitor->name) ?  $visitor->name : ''; ?>" placeholder="নাম লিখুন" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                      	<div class="col-md-3 mb-10">
                            <label for="name_info">তথ্য প্রদানকারীর নাম</label>
                            <input type="text" class="form-control" name="name_info" id="name_info" value="<?php echo isset($visitor->name_info) ?  $visitor->name_info : ''; ?>" placeholder="নাম লিখুন" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="phone">মোবাইল নম্বর</label>
                            <input type="number" class="form-control" name="phone" id="phone" value="<?php echo isset($visitor->phone) ?  $visitor->phone : ''; ?>" placeholder="মোবাইল নম্বর" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="family_member">পরিবারে সদস্য সংখ্যা</label>
                            <input type="number" class="form-control" name="family_member" id="family_member" value="<?php echo isset($visitor->family_member) ?  $visitor->family_member : ''; ?>" placeholder="সদস্য সখ্যা" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="p_number">পরিবারে অসুস্থ ব্যক্তির সংখ্যা</label>
                            <input type="number" class="form-control" name="p_number" id="p_number" value="<?php echo isset($visitor->p_number) ?  $visitor->p_number : ''; ?>" placeholder="অসুস্থ ব্যক্তির সংখ্যা" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                      	<div class="col-md-3 mb-10">
                            <label for="yes_no1">পূর্বে রিডা হসপাতালে কোন সেবা পেয়েছেন কি?</label>
                            <select class="form-control custom-select" name="yes_no1" id="yes_no1">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <option value="yes" <?php echo isset($visitor->yes_no1) && $visitor->yes_no1 =='yes'? 'selected' : ''; ?>>Yes</option>
                                <option value="no" <?php echo isset($visitor->yes_no1) && $visitor->yes_no1 =='no'? 'selected' : ''; ?>>No</option>
                            </select>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="name">মন্তব্য</label>
                            <input type="text" class="form-control" name="comment1" id="name" value="<?php echo isset($visitor->comment1) ?  $visitor->comment1 : ''; ?>" placeholder="মন্তব্য লিখুন">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                      	<div class="col-md-4 mb-10">
                            <label for="yes_no2">পরিবারের মধ্যে গর্ভবর্তী কেউ আছে কি না?</label>
                            <select class="form-control custom-select" name="yes_no2" id="yes_no2">
                            <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <option value="yes" <?php echo isset($visitor->yes_no2) && $visitor->yes_no2 =='yes'? 'selected' : ''; ?>>Yes</option>
                                <option value="no" <?php echo isset($visitor->yes_no2) && $visitor->yes_no2 =='no'? 'selected' : ''; ?>>No</option>
                            </select>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="name">মন্তব্য লিখুন</label>
                            <input type="text" class="form-control" name="comment2" id="name" value="<?php echo isset($visitor->comment2) ?  $visitor->comment2 : ''; ?>" placeholder="মন্তব্য লিখুন">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                      	<div class="col-md-4 mb-10">
                            <label for="yes_no3">পরিবারে জরুীরি চিকিৎসা সেবা প্রয়োজন কেউ আছে কি না?</label>
                            <select class="form-control custom-select" name="yes_no3" id="yes_no3">
                            <?php $treatments = get_visitor_emergency_treatment(); ?>
                                <?php foreach ($treatments as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($visitor->yes_no9) && $visitor->yes_no9 == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                      	<div class="col-md-3 mb-10">
                            <label for="yes_no4">হেলথ কার্ড নিতে আগ্রহী কি না?</label>
                            <select class="form-control custom-select" name="yes_no4" id="yes_no4">
                            <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <option value="yes" <?php echo isset($visitor->yes_no4) && $visitor->yes_no4 =='yes'? 'selected' : ''; ?>>Yes</option>
                                <option value="no" <?php echo isset($visitor->yes_no4) && $visitor->yes_no4 =='no'? 'selected' : ''; ?>>No</option>
                            </select>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="name">মন্তব্য লিখুন</label>
                            <input type="text" class="form-control" name="comment4" id="name" value="<?php echo isset($visitor->comment4) ?  $visitor->comment4 : ''; ?>" placeholder="মন্তব্য লিখুন">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                      	<div class="col-md-3 mb-10">
                            <label for="yes_no5">হেলথ প্যাকেজ নিতে আগ্রহী কি না?</label>
                            <select class="form-control custom-select" name="yes_no5" id="yes_no5">
                            <?php $packages = get_visitor_health_package(); ?>
                                <?php foreach ($packages as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($visitor->yes_no9) && $visitor->yes_no9 == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                      	<div class="col-md-4 mb-10">
                            <label for="yes_no6">মেডিসিন নিতে আগ্রহী কি না?</label>
                            <select class="form-control custom-select" name="yes_no6" id="yes_no6">
                            <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                            <option value="yes" <?php echo isset($visitor->yes_no2) && $visitor->yes_no2 =='yes'? 'selected' : ''; ?>>Yes</option>
                            <option value="no" <?php echo isset($visitor->yes_no2) && $visitor->yes_no2 =='no'? 'selected' : ''; ?>>No</option>
                            </select>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="name">মন্তব্য লিখুন</label>
                            <input type="text" class="form-control" name="comment6" id="name" value="<?php echo isset($visitor->comment6) ?  $visitor->comment6 : ''; ?>" placeholder="মন্তব্য লিখুন">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="yes_no7">ল্যান্ড নিতে আগ্রহী কি না?</label>
                            <select class="form-control custom-select" name="yes_no7" id="yes_no7">
                            <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <option value="yes" <?php echo isset($visitor->yes_no7) && $visitor->yes_no7 =='yes'? 'selected' : ''; ?>>Yes</option>
                                <option value="no" <?php echo isset($visitor->yes_no7) && $visitor->yes_no7 =='no'? 'selected' : ''; ?>>No</option>
                            </select>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="name">মন্তব্য লিখুন</label>
                            <input type="text" class="form-control" name="comment7" id="name" value="<?php echo isset($visitor->comment7) ?  $visitor->comment7 : ''; ?>" placeholder="মন্তব্য লিখুন">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                      	<div class="col-md-3 mb-10">
                            <label for="yes_no8">কোন অপারেশন করতে চান কি না?</label>
                            <select class="form-control custom-select" name="yes_no8" id="yes_no8">
                            <?php $operations = get_visitor_operation(); ?>
                                <?php foreach ($operations as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($visitor->yes_no9) && $visitor->yes_no9 == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                      	<div class="col-md-3 mb-10">
                            <label for="yes_no9">কোন পরীক্ষা করাতে চান কি না?</label>
                            <select class="form-control custom-select" name="yes_no9" id="yes_no9">
                            <?php $tests = get_visitor_test(); ?>
                                <?php foreach ($tests as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($visitor->yes_no9) && $visitor->yes_no9 == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                      	<div class="col-md-3 mb-10">
                            <label for="p_name">দ্রুত চিকিৎসা সেবা নেওয়া ব্যক্তির নাম</label>
                            <input type="text" class="form-control" name="p_name" id="p_name" value="<?php echo isset($visitor->p_name) ?  $visitor->p_name : ''; ?>" placeholder="মন্তব্য লিখুন">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="p_type">অসুস্থ্যতার ধরণ</label>
                            <input type="text" class="form-control" name="p_type" id="p_type" value="<?php echo isset($visitor->p_type) ?  $visitor->p_type : ''; ?>" placeholder="মন্তব্য লিখুন">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                      	<div class="col-md-3 mb-10">
                            <label for="p_department">কোন বিভাগে ডাক্তার দেখাতে চান</label>
                            <input type="text" class="form-control" name="p_department" id="p_department" value="<?php echo isset($visitor->p_department) ?  $visitor->p_department : ''; ?>" placeholder="মন্তব্য লিখুন">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="date">রোগী দেখানোর তারিখ</label>
                            <input type="text" class="form-control" name="date" id="date" value="<?php echo isset($visitor->date) ?  $visitor->date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="p_serial">সিরিয়াল নং</label>
                            <input type="number" class="form-control" name="p_serial" id="p_serial" value="<?php echo isset($visitor->p_serial) ?  $visitor->p_serial : ''; ?>" placeholder="সিরিয়াল নং">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                      	<div class="col-md-2 mb-10">
                            <label for="p_mobile">রোগীর মোবাইল নম্বর</label>
                            <input type="number" class="form-control" name="p_mobile" id="p_mobile" value="<?php echo isset($visitor->p_mobile) ?  $visitor->p_mobile : ''; ?>" placeholder="মোবাইল নম্বর">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="date_fo">জরিপের তারিখ</label>
                            <input type="text" class="form-control" name="date_fo" id="date_fo" value="<?php echo isset($visitor->date_fo) ?  $visitor->date_fo : ''; ?>" placeholder="<?php echo $this->lang->line('date_fo'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                      	                        
                        <div class="col-md-3 mb-10">
                            <label for="attachment">সংযুক্তি</label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="attachment">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="note">সামগ্রিক মন্তব্য লিখুন</label>
                            <input type="text" class="form-control" name="note" id="note" value="<?php echo isset($visitor->note) ?  $visitor->note : ''; ?>" placeholder="মন্তব্য লিখুন">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $visitor->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('frontoffice/visitor'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Time Picker -->
<link rel="stylesheet" href="<?php echo VENDOR_URL; ?>timepicker/bootstrap-timepicker.min.css">
<script src="<?php echo VENDOR_URL; ?>timepicker/bootstrap-timepicker.min.js"></script>

<script>
    $("#date").daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

    /* Time picker*/
    $(".timepicker").timepicker({
        showSeconds: false,
        showMeridian: true,
        showInputs: true,
        disableFocus: false,
        disableMousewheel: true,
        locale: moment.locale('bn')
    });
</script>


<script>
    function get_union(upazila_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_upazila_by_union'); ?>",
            data: {
                upazila_id: upazila_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#union_id').html(response);
                }
            }
        });
    };
    
    function get_village(union_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_union_by_village'); ?>",
            data: {
                union_id: union_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#village_id').html(response);
                }
            }
        });
    };
</script>