<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('history'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('history'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('frontoffice/history'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
        <!-- col-xl-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'frontoffice', 'history')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user font-30 mr-10"></i>
                            <?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('history'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(ADD, 'frontoffice', 'appointment')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('frontoffice/appointment'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('appointment'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('appointment_no'); ?></th>
                                        <th><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('patient'); ?></th>
                                        <th><?php echo $this->lang->line('phone'); ?></th>
                                        <th><?php echo $this->lang->line('doctor'); ?></th>
                                        <th><?php echo $this->lang->line('reference'); ?></th>
                                        <th><?php echo $this->lang->line('created_by'); ?></th>
                                        <th><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($appointments) && !empty($appointments)) { ?>
                                        <?php foreach ($appointments as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo json_decode($obj->old_data)->appointment_no; ?></td>
                                                <td>
                                                    <div class="d-flex flex-column justify-content-center align-items-start">
                                                        <span>
                                                            <i class="fa fa-user text-success"></i>
                                                            <?php echo json_decode($obj->old_data)->date; ?>
                                                        </span>
                                                        <span>
                                                            <i class="fa fa-user <?php echo json_decode($obj->new_data)->date !== json_decode($obj->new_data)->date ? 'text-red' : ''; ?>"></i>
                                                            <?php echo json_decode($obj->new_data)->date; ?>
                                                        </span>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex flex-column justify-content-center align-items-start">
                                                        <span>
                                                            <i class="fa fa-user text-success"></i>
                                                            <?php echo json_decode($obj->old_data)->name; ?>
                                                        </span>
                                                        <span>
                                                            <i class="fa fa-user <?php echo json_decode($obj->new_data)->name !== json_decode($obj->new_data)->name ? 'text-red' : ''; ?>"></i>
                                                            <?php echo json_decode($obj->new_data)->name; ?>
                                                        </span>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex flex-column justify-content-center align-items-start">
                                                        <span>
                                                            <i class="fa fa-user text-success"></i>
                                                            <?php echo json_decode($obj->old_data)->phone; ?>
                                                        </span>
                                                        <span>
                                                            <i class="fa fa-user <?php echo json_decode($obj->old_data)->phone !== json_decode($obj->new_data)->phone ? 'text-red' : ''; ?>"></i>
                                                            <?php echo json_decode($obj->new_data)->phone; ?>
                                                        </span>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex flex-column justify-content-center align-items-start">
                                                        <span>
                                                            <i class="fa fa-user text-success"></i>
                                                            <?php echo json_decode($obj->old_data)->doctor_id ? get_doctor_name(json_decode($obj->old_data)->doctor_id) : ''; ?>
                                                        </span>
                                                        <span>
                                                            <i class="fa fa-user <?php echo json_decode($obj->old_data)->doctor_id !== json_decode($obj->new_data)->doctor_id ? 'text-red' : ''; ?>"></i>
                                                            <?php echo json_decode($obj->new_data)->doctor_id ? get_doctor_name(json_decode($obj->new_data)->doctor_id) : ''; ?>
                                                        </span>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex flex-column justify-content-center align-items-start">
                                                        <span>
                                                            <i class="fa fa-user text-success"></i>
                                                            <?php echo json_decode($obj->old_data)->reference_id ? get_doctor_name(json_decode($obj->old_data)->reference_id) : ''; ?>
                                                        </span>
                                                        <span>
                                                            <i class="fa fa-user <?php echo json_decode($obj->old_data)->reference_id !== json_decode($obj->new_data)->reference_id ? 'text-red' : ''; ?>"></i>
                                                            <?php echo json_decode($obj->new_data)->reference_id ? get_doctor_name(json_decode($obj->new_data)->reference_id) : ''; ?>
                                                        </span>
                                                    </div>
                                                </td>
                                                <td><?php echo $obj->created_by; ?></td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'frontoffice', 'history')) { ?>
                                                        <button type="button" onclick="get_view_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'frontoffice', 'history')) { ?>
                                                        <a class="btn btn-danger btn-xs" href="<?php echo site_url('frontoffice/history/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="9"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('history'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('frontoffice/history/get_single_appointment_history'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>