<!-- Add Employee Modal-->
<div class="modal fade" id="addEmployeeModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('reference'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="addEmployeeForm" enctype="multipart/form-data" method="POST" action="<?php echo site_url('frontoffice/appointment/addemployee'); ?>">
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="name" id="emp_name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('reference'); ?> <?php echo $this->lang->line('name'); ?>" required autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?> <span class="required">*</span></label>
                            <input type="number" class="form-control" name="phone" id="emp_phone" value="<?php echo isset($phone) ?  $phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="commission_type"><?php echo $this->lang->line('commission'); ?> <?php echo $this->lang->line('type'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select" name="commission_type" id="emp_commission_type" required>
                                <option value="vd"><?php echo $this->lang->line('vd'); ?></option>
                                <option value="mbbs"><?php echo $this->lang->line('mbbs'); ?></option>
                                <option value="emp"><?php echo $this->lang->line('emp'); ?></option>
                                <option value="corporate"><?php echo $this->lang->line('corporate'); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="role_id" value="<?php echo VD; ?>">
                        <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Employee Modal -->
<script type="text/javascript">
    function addAppointmentModalClose() {
        $("#addAppointmentModal").modal('hide');
    }
    $(document).ready(function(e) {
        $("#addEmployeeForm").on('submit', (function(e) {
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url('frontoffice/appointment/addemployee'); ?>',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "failed") {
                        var message = "";
                        $.each(data.error, function(index, value) {
                            message += value;
                        });
                        $.toast({
                            text: message,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-danger',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });

                    } else {
                        $.toast({
                            text: data.message,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-primary',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });
                        $("#addAppointmentModal").modal('show');
                        var data = {
                            id: data.emp_user_id,
                            text: data.emp_name + ' [' + data.emp_phone + ']',
                        };
                        var newOption = new Option(data.text, data.id, false, false);
                        $('#add_reference_id').append(newOption).trigger('change');
                        $('#add_reference_id').val(data.id).trigger('change');
                        $('#addEmployeeModal').modal('hide');
                        $('#addEmployeeModal').find('form')[0].reset();
                    }
                }
            });
        }));
    });
</script>