<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Calllog_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_calllog_list($limit, $offset, $search, $count) {
        $this->db->select('C.*,');
        $this->db->from('calllogs AS C');
        if ($search) {
            $this->db->like('C.phone', $search);
            $this->db->or_like('C.name', $search);
            $this->db->or_like('C.call_date', $search);
            $this->db->or_like('C.call_duration', $search);
            $this->db->or_like('C.call_type', $search);
            $this->db->or_like('C.note', $search);
        }
        $this->db->order_by('C.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
}
