<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Calllog.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Calllog
 * @description     : Manage calllog.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Calllog extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Calllog_Model', 'calllog', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Calllog List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $search = $this->input->get('search');
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('frontoffice/calllog/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->calllog->get_calllog_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['calllogs'] = $this->calllog->get_calllog_list($config['per_page'], $offset, $search, $count = FALSE);

        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('call_log') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('calllog/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new Calllog" user interface
     *                    and process to store "calllogs" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add() {

        check_permission(ADD);
        if ($_POST) {
            $this->_prepare_calllog_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_calllog_data();
                $insert_id = $this->calllog->insert('calllogs', $data);
                if ($insert_id) {
                    create_log('Has been created a Calllog : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('frontoffice/calllog');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('frontoffice/calllog/add');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('call_log') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('calllog/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Calllog" user interface
     *                    with populate "Calllog" value
     *                    and process to update "calllogs" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit($id = null) {

        check_permission(EDIT);
        if ($_POST) {
            $this->_prepare_calllog_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_calllog_data();
                $updated = $this->calllog->update('calllogs', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Calllog : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('frontoffice/calllog');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('frontoffice/calllog/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['calllog'] = $this->calllog->get_single('calllogs', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['calllog'] = $this->calllog->get_single('calllogs', array('id' => $id));
                if (!$this->data['calllog']) {
                    redirect('frontoffice/calllog');
                }
            }
        }

        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('call_log') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('calllog/edit', $this->data);
    }

    /*****************Function _prepare_calllog_validation**********************************
     * @type            : Function
     * @function name   : _prepare_calllog_validation
     * @description     : Process "Calllog" user input data validation
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    private function _prepare_calllog_validation() {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
        $this->form_validation->set_rules('name', $this->lang->line('calllog') . ' ' . $this->lang->line('name'), 'trim|required');
        $this->form_validation->set_rules('phone', $this->lang->line('phone'), 'trim|required');
        $this->form_validation->set_rules('call_date', $this->lang->line('date'), 'trim|required');
    }

    /*****************Function _get_posted_calllog_data**********************************
     * @type            : Function
     * @function name   : _get_posted_calllog_data
     * @description     : Prepare "Calllog" user input data to save into database
     *
     * @param           : null
     * @return          : $data array(); value
     * ********************************************************** */
    private function _get_posted_calllog_data() {

        $items = array();
        $items[] = 'name';
        $items[] = 'phone';
        $items[] = 'call_duration';
        $items[] = 'note';
        $data = elements($items, $_POST);

        $data['call_date'] = $this->input->post('call_date') ? date('Y-m-d', strtotime($this->input->post('call_date'))) : NULL;
        $data['next_follow_up'] = $this->input->post('next_follow_up') ? date('Y-m-d', strtotime($this->input->post('next_follow_up'))) : NULL;
        $data['call_type'] = $this->input->post('call_type') ? $this->input->post('call_type') : 0;

        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {
            $data['status'] = 1;
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
        }

        return $data;
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Calllog" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('frontoffice/calllog');
        }

        $calllog = $this->calllog->get_single('calllogs', array('id' => $id));

        if ($this->calllog->delete('calllogs', array('id' => $id))) {
            create_log('Has been deleted a Calllog : ' . $calllog->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect('frontoffice/calllog');
    }
}
