<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('menu'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_menu'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('frontend/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">

                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'frontend', 'menu')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bars font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('menu'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'frontend', 'menu')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('frontend/menu'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('menu'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('frontend/menu/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="location"><?php echo $this->lang->line('location'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select" name="location" id="location" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $locations = get_menu_location(); ?>
                                <?php foreach ($locations as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($location) && $location == $key  ?  'selected="selected"' : ''; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="location" class="form-text text-muted">
                                <?php echo form_error('location'); ?>
                            </small>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="name"><?php echo $this->lang->line('menu'); ?> <?php echo $this->lang->line('name'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('menu'); ?> <?php echo $this->lang->line('name'); ?>" required>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="bn_name"><?php echo $this->lang->line('bn_name'); ?></label>
                            <input type="text" class="form-control" name="bn_name" id="bn_name" value="<?php echo isset($bn_name) ?  $bn_name : ''; ?>" placeholder="<?php echo $this->lang->line('bn_name'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="sort_by"><?php echo $this->lang->line('sort_by'); ?></label>
                            <input type="number" class="form-control" name="sort_by" id="sort_by" value="<?php echo isset($sort_by) ?  $sort_by : ''; ?>" placeholder="<?php echo $this->lang->line('sort_by'); ?>">
                        </div>
                        <div class="col-md-8 mb-10">
                            <label for="note"><?php echo $this->lang->line('remark'); ?></label>
                            <input type="text" class="form-control" name="note" id="note" value="<?php echo isset($note) ?  $note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                        </div>
                        <div class="col-md-2 mt-40">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" checked>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('frontend/menu'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->