<!--Add Appointment Modal-->
<div class="modal fade" id="existingPaytentModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header">
                <h5 class="modal-title mr-30"><?php echo $this->lang->line('existing') . " " . $this->lang->line('patient'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-row">
                    <div class="col-md-6 mb-10 mx-auto">
                        <div class="input-group">
                            <input type="number" min="0" class="form-control" name="search" id="searchPatient" placeholder="<?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('search'); ?>" required autocomplete="off">
                            <div class="input-group-append">
                                <button onclick="searchPatient()" class="btn btn-gradient-primary">Search</button>
                            </div>
                        </div>
                        <small class="text-muted">Only patient unique ID search able</small>
                    </div>
                </div>
                <div class="form-row" id="viewPatientInfo"></div>
                <?php echo form_open_multipart(site_url('followup/patient/existing'), array('name' => 'existingPatientForm', 'id' => 'existingPatientForm', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="form-row" id="viewPatientForm">
                    <div class="col-md-6 mb-10">
                        <label for="existing_category_id"><?php echo $this->lang->line('category'); ?> <span class="required">*</span></label>
                        <select class="form-control select2" name="category_id" id="existing_category_id" required>
                            <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('category'); ?></option>
                            <?php foreach ($categories as $obj) { ?>
                                <option value="<?php echo $obj->id; ?>"><?php echo $obj->name; ?> [<?php echo $obj->day; ?>]</option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-6 mb-10">
                        <label for="existing_note"><?php echo $this->lang->line('remark'); ?></label>
                        <input type="text" class="form-control" id="existing_note" name="note" value="<?php echo isset($note) ?  $note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                    </div>
                    <div class="col-md-12 mt-10">
                        <input type="hidden" id="existing_patient_id" name="patient_id">
                        <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button type="submit" class="btn btn-gradient-primary"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>

<style>
    #viewPatientForm {
        display: none;
    }
</style>
<script>
    function searchPatient() {
        if ($("#searchPatient").val() != "") {
            $.ajax({
                url: '<?php echo site_url('followup/patient/search') ?>',
                type: "POST",
                data: {
                    'search': $("#searchPatient").val()
                },
                success: function(data) {
                    const item = JSON.parse(data);
                    if (item.patient === null) {
                        document.getElementById('viewPatientInfo').innerHTML = "";
                        document.getElementById('viewPatientForm').style.display = "none";
                        $.toast({
                            text: 'No Patient Found!!! Please search again',
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-danger',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });
                    } else {
                        let viewPatientInfoData = `
                        <div class="col-md-12 mb-10">
                            <div class="table-responsive">
                                <table class="table table-sm table-dark table-bordered text-white">
                                    <thead>
                                        <tr>
                                            <th colspan="4" class="text-center">Patient Info</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Patient ID</td>
                                            <td>${item.patient.patient_unique_id}</td>
                                            <td>Patient Name</td>
                                            <td>${item.patient.name}</td>
                                        </tr>
                                        <tr>
                                            <td>Mobile</td>
                                            <td>${item.patient.phone}</td>
                                            <td>Address</td>
                                            <td>${item.patient.address}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        `;
                        document.getElementById('viewPatientInfo').innerHTML = viewPatientInfoData;
                        document.getElementById('existing_patient_id').value = item.patient.user_id;
                        document.getElementById('viewPatientForm').style.display = "block";
                        document.getElementById('viewPatientForm').style.display = "flex";
                        $.toast({
                            text: 'Success Patient Found',
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-primary',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });
                    }
                },
                error: function() {
                    alert("Fail")
                }
            });
        } else {
            $.toast({
                text: "Please filled up seacrh  field",
                position: 'top-right',
                loaderBg: '#7a5449',
                class: 'jq-toast-danger',
                hideAfter: 3500,
                stack: 6,
                showHideTransition: 'fade'
            });
        }
    }


    $(document).ready(function(e) {
        $("#existingPatientForm").on('submit', (function(e) {
            e.preventDefault();
            $('button[type=submit]').attr('disabled', true);
            if ($("#existing_patient_id").val() != "" && $("#existing_category_id").val() != "") {
                $.ajax({
                    url: '<?php echo site_url('followup/patient/existing') ?>',
                    type: "POST",
                    data: new FormData(this),
                    dataType: 'json',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(data) {
                        if (data.status == "failed") {
                            var message = "";
                            $.each(data.error, function(index, value) {
                                $("." + index).html(value);
                                message += value;
                            });
                            $.toast({
                                text: message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-danger',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                        } else {
                            $.toast({
                                text: data.message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-primary',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                            window.location.href = "<?php echo site_url('followup/patient'); ?>";
                        }
                    },
                    error: function() {
                        alert("Fail")
                    }
                });
            } else {
                $.toast({
                    text: "Please select all required field",
                    position: 'top-right',
                    loaderBg: '#7a5449',
                    class: 'jq-toast-danger',
                    hideAfter: 3500,
                    stack: 6,
                    showHideTransition: 'fade'
                });
            }
        }));
    });
</script>