<!DOCTYPE html>
<html>

<head>
    <title>Report Print</title>
    <style>
        body {
            font-family: "Times New Roman", serif;
            font-size: 13px;
            margin: 0;
            padding: 0;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            margin-top: 160px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            border: 1px solid #000;
        }
        
        .table_reg {
            width: 100%;
            border-collapse: collapse;
            border: 1px solid #000;
            border-bottom: none;
        }

        .table_patient thead th {
            padding: 0;
            vertical-align: middle;
            border: 0px solid #000;
            font-size: 13px;
        }

        .table_patient tbody td {
            padding: 3px;
            vertical-align: middle;
            border: 0;
            font-size: 14px;
            border-bottom: 1px dotted #000;
        }
      
        .table_rvalue{
            width: 100%;
            border: 0.5px solid #000;
            margin-top: 10px;
        }

        .results-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            border: 1px solid #000;
        }

        .results-table th {
            background-color: #f5f5f5;
            padding: 8px;
            border: 1px solid #000;
            font-weight: bold;
            text-align: left;
        }

        .results-table td {
            padding: 8px;
            border: 1px solid #000;
            vertical-align: top;
        }

        .report {
            margin-top: 10px;
            min-height: 530px;
            font-size: 12px;
        }

        .report table td {
            padding-left: 3px;
            vertical-align: middle;
        }

        .footer {
            margin-top: 30px;
            clear: both;
        }

        .footer p {
            font-size: 10px;
        }

        .footer strong {
            font-size: 10px;
        }

        .signature-area {
            border-top: 1px solid #000;
            padding-top: 10px;
            margin-top: 20px;
        }

        @media print {
            body {
                font-size: 12px;
            }
            
            .main_body {
                margin-top: 100px;
            }
            
            .footer {
                position: fixed;
                bottom: 20px;
                width: 100%;
            }
        }
    </style>
    
    <?php if (isset($this->global_setting->custom_css) && $this->global_setting->custom_css) { ?>
    <style>
        <?php echo $this->global_setting->custom_css; ?>
    </style>
    <?php } ?>
</head>

<body>
<div class="page">
        <div class="main_body">
          
          <table style="width: 100%;">
          	<tr>
              <td style="width: 25%;">
                <img src="<?php echo defined('IMG_URL') ? IMG_URL : base_url('assets/images/'); ?>report_barcode.png" alt="Barcode" width="50%" onerror="this.style.display='none';">
              </td>
              <td style="width: 50%;">
              	<div style="text-align: center; vertical-align: bottom; font-size: 15px; font-weight: bold; text-transform: uppercase; margin-bottom: 10px;">
                    <?php echo isset($template->group) ? htmlspecialchars($template->group) : 'DIAGNOSTIC'; ?> Report
                </div>
              </td>
              <td style="text-align: right; width: 25%;">
              	<img src="<?php echo defined('IMG_URL') ? IMG_URL : base_url('assets/images/'); ?>report_barcode.png" alt="Barcode" width="50%" onerror="this.style.display='none';">
              </td>            
            </tr>
          </table>    
          <table class="table table_patient">
                <tbody>
                    <tr>
                        <td width="14%" style="border-right:none;"><b>ID No:</b></td>
                        <td width="1%" style="border-left:none; border-right:none;"><b>:</b></td>
                        <td style="border-left:none; border-right:none; text-transform:uppercase"><b><?php echo isset($template->patient_unique_id) ? htmlspecialchars($template->patient_unique_id) : 'N/A'; ?></b></td>
                        <td style="border-left:none; border-right:none;"> </td>
                        <td width="35%" style="border-left:none; border-right:none;"><b>Invoice no:</b> <?php echo isset($template->custom_invoice_id) ? htmlspecialchars($template->custom_invoice_id) : 'N/A'; ?></td>
                        
                    </tr>
                    <tr>
                        <td width="14%" style="border-right:none;"><b>Name</b></td>
                        <td width="1%" style="border-left:none; border-right:none;">:</td>
                        <td style="border-left:none; border-right:none;"><b><?php echo isset($template->patient) ? htmlspecialchars($template->patient) : 'N/A'; ?></b></td>
                        <td style="border-right:none;"></td>
                        <td style="border-left:none; border-right:none;"><b>Received Date:</b> <?php echo isset($template->billcreate) ? date('d/m/Y', strtotime($template->billcreate)) : 'N/A'; ?></td>
                        
                    </tr>
                  	<tr>
                        <td width="14%" style="border-right:none;"><b>Age:</b></td>
                        <td width="1%" style="border-left:none; border-right:none;">:</td>
                        <td style="border-left:none; border-right:none;"><?php echo isset($template->dob) ? calculate_age($template->dob) : 'N/A'; ?></td>
                        <td style="border-right:none;"></td>
                        <td style="border-left:none; border-right:none;"><b>Specimen:</b> <span style="text-transform:uppercase"><?php echo isset($template->specimen) ? htmlspecialchars($template->specimen) : 'N/A'; ?></span></td>
                    </tr>
                    <tr>
                        <td width="14%" style="border-right:none;"><b>Gender:</b></td>
                        <td width="1%" style="border-left:none; border-right:none;">:</td>
                        <td style="border-left:none; border-right:none;"><?php echo isset($template->gender) ? $this->lang->line($template->gender) : 'N/A'; ?></td>
                        <td style="border-right:none;"></td>
                        <td style="border-left:none; border-right:none;"><b>Mobile:</b> <?php echo isset($template->mobile) ? htmlspecialchars($template->mobile) : 'N/A'; ?> </td>
                    </tr>
                    
                    <tr>
                        <td width="14%" style="border-right:none;"><b>Refd. By</b></td>
                        <td width="1%" style="border-left:none; border-right:none;">:</td>
                        <td colspan="3" style="border-left:none;">
                            <?php 
                            if (isset($template->self) && $template->self) {
                                echo 'Self';
                            } elseif (isset($template->ref_dr_id) && $template->ref_dr_id > 0) {
                                echo htmlspecialchars($template->doctor . ', ' . $template->specialist);
                            } elseif (isset($template->ref_dr_name)) {
                                echo htmlspecialchars($template->ref_dr_name);
                            } else {
                                echo 'N/A';
                            }
                            ?>
                        </td>
                    </tr>
                
                    <?php if (isset($template->remark) && !empty($template->remark)) { ?>
                        <tr>
                            <td width="14%" style="border-right:none;"><b>Remark:</b></td>
                            <td width="1%" style="border-left:none; border-right:none;"><b>:</b></td>
                            <td colspan="2" style="border-left:none;"><?php echo htmlspecialchars($template->remark); ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>          
            

            <!-- Report Body Start-->
            <?php if (isset($test_results) && is_array($test_results) && !empty($test_results)) { ?>
            <table class="results-table">
                <thead>
                    <tr>
                        <th>Test Parameter</th>
                        <th>Result</th>
                        <th>Normal Value</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $sl = 1;
                    foreach ($test_results as $result) { 
                        // Get result option name if exists
                        $option_name = '';
                        if (isset($result['result_option']) && $result['result_option']) {
                            $option = $this->db->get_where('diagnostic_tests_option', array('id' => $result['result_option']))->row();
                            $option_name = $option ? $option->option_name : '';
                        }
                    ?>
                        <tr>
                            <td><?php echo isset($result['investigation_name']) ? $result['investigation_name'] : 'N/A'; ?></td>
                            <td>
                                <?php echo isset($result['result']) ? $result['result'] : 'N/A'; ?>
                                <?php if ($option_name) { ?>
                                    <br><small>(<?php echo $option_name; ?>)</small>
                                <?php } ?>
                            </td>
                            <td><?php echo isset($result['normal_value']) ? $result['normal_value'] : 'N/A'; ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
            <?php } else { ?>
                <div style="text-align: center; padding: 20px; border: 1px solid #ccc; margin-top: 20px;">
                    <p>No test results available</p>
                </div>
            <?php } ?>
            <!-- Report Body End-->

            <!-- Footer -->
            <div class="footer signature-area" style="width: 100%;">
                <div style="width: 30%; float: left; text-align: center;">
                    <div style="border-top: 1px solid #000; padding-top: 5px; margin-top: 20px;">
                        <?php echo isset($signature_1->name) && !empty($signature_1->name) ? htmlspecialchars($signature_1->name) : '&nbsp;'; ?>
                    </div>
                </div>
                <div style="width: 30%; margin: 0 5%; float: left; text-align: center;">
                    <div style="border-top: 1px solid #000; padding-top: 5px; margin-top: 20px;">
                        <?php echo isset($signature_2->name) && !empty($signature_2->name) ? htmlspecialchars($signature_2->name) : '&nbsp;'; ?>
                    </div>
                </div>
                <div style="width: 30%; float: left; text-align: center;">
                    <div style="border-top: 1px solid #000; padding-top: 5px; margin-top: 20px;">
                        <?php echo isset($signature_3->name) && !empty($signature_3->name) ? htmlspecialchars($signature_3->name) : '&nbsp;'; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        window.onload = function() {
            // Add a small delay to ensure all content is loaded
            setTimeout(function() {
                window.print();
            }, 500);
        }
    </script>
</body>
</html> 