<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Template_Old_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_template_list($limit = null, $offset = null, $search = null, $count = false) {
        
        $this->db->select('t.*, d.name as department, g.name as group, dt.name as test_name');
        $this->db->distinct();
        $this->db->from('diagnostic_templates t');
        $this->db->join('diagnostic_departments d', 'd.id = t.department_id', 'left');
        $this->db->join('diagnostic_groups g', 'g.id = t.group_id', 'left');
        $this->db->join('diagnostic_tests dt', 'dt.id = t.test_id', 'left');
        
        if ($search) {
            $this->db->like('t.name', $search);
        }
        
        $this->db->where('t.status', 1);
        $this->db->order_by('t.id', 'DESC');
        
        if ($count) {
            return $this->db->count_all_results();
        }
        
        if ($limit) {
            $this->db->limit($limit, $offset);
        }
        
        return $this->db->get()->result();
    }

    public function get_single_template($id) {
        $this->db->select('DT.*, D.name as department, G.name as group, T.name as test_name');
        $this->db->from('diagnostic_templates AS DT');
        $this->db->join('diagnostic_departments AS D', 'D.id = DT.department_id', 'left');
        $this->db->join('diagnostic_groups AS G', 'G.id = DT.group_id', 'left');
        $this->db->join('diagnostic_tests AS T', 'T.id = DT.test_id', 'left');
        $this->db->where('DT.id', $id);
        return $this->db->get()->row();
    }
}
