<!DOCTYPE html>
<html>

<head>
    <title>Print Office Invoice</title>

    <style>
        body {
            font-family: monospace;
            font-size: 14px;
        }

        .page {
            width: 60%;
            margin: 0 auto;
        }

        @page {
            size: A4;
            margin: 0;
        }

        @media print {

            html,
            body {
                font-family: Arial, Helvetica, sans-serif;
            }

            .page {
                width: 60%;
                margin: 0 auto;
                border: initial;
                border-radius: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
                page-break-after: always;
            }
        }

        .patient_copy {
            page-break-after: always;
            display: block;
            margin-top: 120px;
            min-height: 600px;
            position: relative;
        }

        .diagnostic_copy {
            display: block;
            margin-top: 100px;
            min-height: 600px;
            page-break-after: always;
            position: relative;
        }

        .diagnostic_copy2 {
            display: block;
            margin-top: 100px;
            min-height: 600px;
            position: relative;
        }

        .title {
            width: 80%;
            font-size: 12px;
            font-weight: bold;
            border: 1px solid #333;
            padding: 5px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 2px;
            border-radius: 3px;
            text-align: center;
            margin: 3px auto;
        }

        .paid {
            width: 25%;
            margin: 30px auto 0 auto;
            text-align: center;
            font-size: 25px;
            font-weight: bold;
            background: #eee;
            border: 0.5px solid #b4b4b4;
            padding: 3px 10px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 5px;
            border-radius: 3px;
        }

        .table {
            font-size: 14px;
            width: 100%;
            border-collapse: collapse;
        }

        .patient_table {
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            margin-top: 5px;
            border: 0.5px solid #b4b4b4;
        }

        .patient_table tbody td {
            color: #000;
            padding: 2px;
            vertical-align: top;
            border: 0;
        }

        /* test_table */
        .test_table {
            margin-top: 10px;
            width: 100%;
            text-align: left;
            font-size: 12px;
            border-collapse: collapse;
            border: 0.5px solid #b4b4b4;
        }

        .test_table tbody td {
            color: #000;
            padding: 0px 4px;
            vertical-align: top;
            border-top: 0.5px solid #b4b4b4;
        }

        /*  payment_info*/
        .payment_table {
            font-size: 14px;
            width: 100%;
            text-align: left;
        }

        .payment_table tbody td {
            vertical-align: top;
            border: 0;
        }

        .powered_by {
            writing-mode: vertical-lr;
            -webkit-transform: rotate(180deg);
            -moz-transform: rotate(180deg);
            font-size: 8px;
            font-family: 'Times New Roman', Times, serif;
            position: absolute;
            left: -15px;
            top: 80px;
            color: #000;
        }

        .table .top-header thead,
        tbody th,
        td {
            border: 0;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="patient_copy">
            <table class="table">
            <tr>
                <td rowspan="3" width="20%" style="margin-bottom:10px">
                    <?php if($this->global_setting->brand_logo){ ?>
                        <img width="80" valign="middle" align="center" src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $this->global_setting->brand_logo; ?>">
                    <?php } else { ?>
                        <img width="80" valign="middle" align="center" src="<?php echo IMG_URL; ?>logo.png">
                    <?php } ?>
                </td>
                <td width="80%" align="center"><h1 style="margin: 0px; padding:0; font-size: 25px;"><?php echo $this->global_setting->brand_title; ?></h1></td>
            </tr>
            <tr>
                <td align="center"><p style="margin: 0px; padding: 0; font-size: 14px;"><?php echo $this->global_setting->address; ?></p></td>
            </tr>
            <tr>
                 <td align="center"><p style="margin: 0; font-size: 14px;">Phone: <?php echo $this->global_setting->phone; ?></p></td>
            </tr>
        </table>
          <table style="margin-top: 10px;" class="table">
          	<tr>
              <td style="width: 25%;">
                <img align="left" src="<?php echo site_url('opd/set_barcode/' . $patient->patient_unique_id); ?>" alt="" height="30" width="80%">
              </td>
              <td>
              	<div class="title">Office Copy</div>
              </td>
              <td style="width: 25%;">
              	<img align="right" src="<?php echo site_url('opd/set_barcode/' . $patient->patient_unique_id); ?>" alt="" height="30" width="80%">
              </td>            
            </tr>
          </table>
            
            <!-- Patient Info Start-->
            <table class="table patient_table">
              <tr>
                    <td style="width: 45%;">
                        <span>Name :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient; ?></span>
                    </td>
                	<td style="width: 55%;">
                        <span>Patient ID :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient_unique_id; ?></span>
                    </td>
                </tr>  
              <tr>
                  <td style="width: 40%;">
                        <span>Age :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo get_age($patient->dob); ?></span>
                    </td>
                    <td style="width: 60%;">
                        <span>Bill No :</span>
                        <span><?php echo $patient->custom_invoice_id; ?></span>
                    </td>
                </tr>
                <tr>
                    <td style="width: 40%;">
                        <span>Gender :</span>
                        <span style="text-transform: capitalize; font-weight: bold;"><?php echo $this->lang->line($patient->gender); ?></span>
                    </td>
                    <td style="width: 60%;">
                        <span>Registered on :</span>
                        <span><?php echo date('d/m/Y h:i A', strtotime($patient->bill_date)); ?></span>
                    </td>
                </tr>
              	<tr>                   
                    <td style="width: 40%;">
                        <span>Contact No :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->phone; ?></span>
                    </td>
                    <td style="width: 60%;">
                          <span>Date :</span>
                          <span><?php echo date('d/m/Y h:i A', strtotime($patient->bill_date)); ?></span>
                  </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <span>Ref. By :</span>
                        <span style="font-size:12px; text-transform: uppercase; font-weight: bold;">
                            <?php
                            if ($patient->self == 1) {
                                echo 'Self';
                            } elseif ($patient->ref_dr_id == NULL) {
                                echo $patient->ref_dr_name;
                            } else {
                                echo $patient->refdr . ', ' . $patient->specialist;
                            }
                            ?>
                        </span>
                    </td>
                </tr>
            </table>
            <!-- Patient Info End-->

            <?php if (isset($tests) & !empty($tests)) { ?>
                <table class="test_table">
                    <tbody>
                        <tr>
                            <td width="15%" align="left"><b>SL. No</b></td>
                            <td width="55%" align="left"><b>Test Name</b></td>
                            <td width="30%" align="right"><b>Price (Tk.)</b></td>
                        </tr>
                        <?php $count = 1; ?>
                        <?php foreach ($tests as $obj) { ?>
                            <tr>
                                <td width="15%" align="left"><?php echo $count++; ?></td>
                                <td width="55%" align="left"><?php echo $obj->test_name; ?></td>
                                <td width="30%" align="right"><?php echo $obj->total_rate; ?></td>
                            </tr>
                        <?php } ?>
                        <?php foreach ($tubes as $obj) { ?>
                            <tr>
                                <td width="15%" align="left"><?php echo $count++; ?></td>
                                <td width="55%" align="left"><?php echo $obj->tube; ?></td>
                                <td width="30%" align="right"><?php echo $obj->total_rate; ?></td>
                            </tr>
                        <?php } ?>
                        <tr>
                            <td colspan="3">
                                <table class="table">
                                    <tr>
                                        <td width="58%" style="border: 0;">
                                            <div class="paid" style="margin-bottom: 0; padding-bottom: 0;">
                                                <?php if ($patient->paid_status == 'paid') {
                                                    echo 'Paid';
                                                } else {
                                                    echo 'Due';
                                                } ?>
                                            </div>
                                            <p style="text-align: center; margin-bottom: 20px;"><b>In Word:</b> <span style="font-size: 12px;"><?php echo $this->numbertowords->convert_number($invoice->advanced); ?> Taka Only.</span></p>
                                        </td>
                                        <td width="42%" style="border: 0;">
                                            <table class="table">
                                                <tr>
                                                    <td style="border: 0;text-align: left;">Item Total Tk.</td>
                                                    <td style="border: 0;text-align: right;"><?php echo $invoice->total_bill; ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="border-top: 1px dashed #ccc;text-align: left;">(-)Discount Tk.</td>
                                                    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo number_format(($invoice->discount + $invoice->special_discount), 2); ?></td>
                                                </tr>
                                                <!--<tr>-->
                                                <!--    <td style="border-top: 1px dashed #ccc;text-align: left;">(-)Covid-19 Disc. Tk.</td>-->
                                                <!--    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo number_format($invoice->special_discount, 2); ?></td>-->
                                                <!--</tr>-->
                                                <tr>
                                                    <td style="border-top: 1px dashed #ccc;text-align: left;">Net Payable Tk.</td>
                                                    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo $invoice->net_payable; ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="border-top: 1px dashed #ccc;text-align: left;">Advance Tk.</td>
                                                    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo $invoice->advanced; ?></td>
                                                </tr>
                                                <tr>
                                                    <td style="border-top: 1px dashed #ccc;text-align: left;">Due Tk.</td>
                                                    <td style="border-top: 1px dashed #ccc;text-align: right;"><?php echo $invoice->due_amount; ?></td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
            <?php } ?>
            <?php if ($invoice->note != NULL) { ?>
                <p style="margin-top:20px;">
                    <b>Remark: </b>
                    <?php echo $invoice->note; ?>
                </p>
            <?php } ?>
            <p style="margin-top:10px; font-size: 13px; font-weight: bold;">
                <span>ROOM NUMBER:</span>
                <span style="font-size: 12px; text-transform: uppercase;">
                    <?php foreach ($rooms as $room) {
                        echo $room->specimen . ' : ' . $room->room_no . ', ';
                    } ?>
                </span>
            </p>
            <p style="margin-top:30px;">
                <span style="font-size: 14px; font-weight: bold;">Prepared By:</span>
                <?php echo $patient->created_by; ?>
            </p>
        </div>
    </div>
</body>

</html>