<div class="table-wrap">
	<div class="table-responsive">
		<table class="table table-sm text-white">
			<tbody>
				<tr>
					<td><?php echo $this->lang->line('name'); ?></td>
					<td><?php echo $attendance->name; ?></td>
					<td><?php echo $this->lang->line('phone'); ?></td>
					<td><?php echo $attendance->phone; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('department'); ?></td>
					<td><?php echo $attendance->department; ?></td>
					<td><?php echo $this->lang->line('designation'); ?></td>
					<td><?php echo $attendance->designation; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('device_id'); ?></td>
					<td><?php echo $attendance->device_id; ?></td>
					<td><?php echo $this->lang->line('shift'); ?></td>
					<td><?php echo $attendance->shift; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('type'); ?></td>
					<td><?php echo $attendance->is_manual ? $this->lang->line('manual') : $this->lang->line('machine'); ?></td>
					<td><?php echo $this->lang->line('punch_type'); ?></td>
					<td><?php echo $this->lang->line($attendance->punch_type); ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('date'); ?></td>
					<td><?php echo date('M d, Y', strtotime($attendance->date)); ?></td>
					<td><?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('status'); ?></td>
					<td><?php echo get_attendance_badge($attendance->attendance_status); ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('clock_in'); ?></td>
					<td><?php echo $attendance->clock_in ? date('h:ia', strtotime($attendance->clock_in)) : ''; ?></td>
					<td><?php echo $this->lang->line('clock_out'); ?></td>
					<td><?php echo $attendance->clock_out ? date('h:ia', strtotime($attendance->clock_out)) : ''; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('lunch_out'); ?>
					<td><?php echo $attendance->lunch_out ? date('h:ia', strtotime($attendance->lunch_out)) : ''; ?></td>
					<td><?php echo $this->lang->line('lunch_in'); ?></td>
					<td><?php echo $attendance->lunch_in ? date('h:ia', strtotime($attendance->lunch_in)) : ''; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('late'); ?></td>
					<td>
						<?php
						if ($attendance->late) {
							echo date('H', strtotime($attendance->late)) > 0 ? date('H', strtotime($attendance->late)) . 'H ' : '';
							echo date('i', strtotime($attendance->late)) > 0 ?  date('i', strtotime($attendance->late)) . 'M' : '';
						} ?>
					</td>
					<td><?php echo $this->lang->line('early_leaving'); ?></td>
					<td>
						<?php
						if ($attendance->early_leaving) {
							echo date('H', strtotime($attendance->early_leaving)) > 0 ? date('H', strtotime($attendance->early_leaving)) . 'H ' : '';
							echo date('i', strtotime($attendance->early_leaving)) > 0 ?   date('i', strtotime($attendance->early_leaving)) . 'M' : '';
						} ?>
					</td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('overtime'); ?></td>
					<td>
						<?php
						if ($attendance->overtime) {
							echo date('H', strtotime($attendance->overtime)) > 0 ? date('H', strtotime($attendance->overtime)) . 'H ' : '';
							echo date('i', strtotime($attendance->overtime)) > 0 ?   date('i', strtotime($attendance->overtime)) . 'M' : '';
						} ?>
					</td>
					<td><?php echo $this->lang->line('total'); ?></td>
					<td>
						<?php
						if ($attendance->total) {
							echo date('H', strtotime($attendance->total)) > 0 ? date('H', strtotime($attendance->total)) . 'H ' : '';
							echo date('i', strtotime($attendance->total)) > 0 ? date('i', strtotime($attendance->total)) . 'M' : '';
						} ?>
					</td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('remark'); ?></td>
					<td colspan="3"><?php echo $attendance->remark; ?></td>
				</tr>

				<?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
					<tr>
						<td><?php echo $this->lang->line('created_by'); ?></td>
						<td><?php echo $attendance->created_by; ?></td>
						<td><?php echo $this->lang->line('created'); ?></td>
						<td><?php echo date('M d, Y h:ia', strtotime($attendance->created_at)); ?></td>
					</tr>
					<tr>
						<td><?php echo $this->lang->line('modified_by'); ?></td>
						<td><?php echo $attendance->modified_by; ?></td>
						<td><?php echo $this->lang->line('modified'); ?></td>
						<td><?php echo $attendance->modified_by ? date('M d, Y h:ia', strtotime($attendance->modified_at)) : ''; ?>
						</td>
					</tr>
				<?php } else { ?>
					<tr>
						<td><?php echo $this->lang->line('created_by'); ?></td>
						<td><?php echo $attendance->created_by; ?></td>
						<td><?php echo $this->lang->line('created'); ?></td>
						<td><?php echo date('M d, Y h:ia', strtotime($attendance->created_at)); ?></td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
</div>