<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('attendance'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_attendance'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('attendance'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="shift_id"><?php echo $this->lang->line('shift'); ?></label>
                            <select class="form-control custom-select select2" name="shift_id" id="shift_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('shift'); ?></option>
                                <?php foreach ($shifts as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($shift_id) && $shift_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="type" id="type">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <option value="manual" <?php echo isset($type) && $type == 'manual' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('manual'); ?></option>
                                <option value="machine" <?php echo isset($type) && $type == 'machine' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('machine'); ?></option>
                                <option value="card" <?php echo isset($type) && $type == 'card' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('card'); ?></option>
                                <option value="finger" <?php echo isset($type) && $type == 'finger' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('finger'); ?></option>
                                <option value="face" <?php echo isset($type) && $type == 'face' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('face'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="attendance_status"><?php echo $this->lang->line('status'); ?></label>
                            <select class="form-control custom-select" name="attendance_status" id="attendance_status">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $status = get_attendance_status(); ?>
                                <?php foreach ($status as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($attendance_status) && $attendance_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="user_id"><?php echo $this->lang->line('employee'); ?></label>
                            <select class="form-control custom-select select2" name="user_id" id="user_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($user_id) && $user_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?></label>
                            <select class="form-control custom-select select2" name="department_id" id="department_id" onchange="get_designation(this.value)">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('department'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="designation_id"><?php echo $this->lang->line('designation'); ?></label>
                            <select class="form-control custom-select select2" name="designation_id" id="designation_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('designation'); ?></option>
                                <?php foreach ($designations as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($designation_id) && $designation_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
        <!-- col-xl-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'attendance', 'attendance')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-clock-o font-30 mr-10"></i>
                            <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(ADD, 'attendance', 'attendance')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('attendance/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('attendance'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0 table-hover">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th class="w-15"><?php echo $this->lang->line('shift'); ?></th>
                                        <th class="w-15"><?php echo $this->lang->line('date'); ?></th>
                                        <th class="w-10"><?php echo $this->lang->line('clock_in'); ?></th>
                                        <th class="w-10"><?php echo $this->lang->line('clock_out'); ?></th>
                                        <th><?php echo $this->lang->line('late'); ?></th>
                                        <th><?php echo $this->lang->line('early_leaving'); ?></th>
                                        <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('hour'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th><?php echo $this->lang->line('remark'); ?></th>
                                        <th class="w-15"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($attendances) && !empty($attendances)) { ?>
                                        <?php foreach ($attendances as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td>
                                                    <?php echo $obj->shift; ?><br />
                                                    <strong>In:</strong><?php echo date('h:ia', strtotime($obj->in_time)); ?><br />
                                                    <strong>Out:</strong><?php echo date('h:ia', strtotime($obj->out_time)); ?>
                                                </td>
                                                <td><?php echo date('M d, Y', strtotime($obj->date)); ?></td>
                                                <td><?php echo $obj->clock_in ? date('h:ia', strtotime($obj->clock_in)) : ''; ?></td>
                                                <td><?php echo $obj->clock_out ? date('h:ia', strtotime($obj->clock_out)) : ''; ?></td>
                                                <td>
                                                    <?php
                                                    if ($obj->late) {
                                                        echo date('H', strtotime($obj->late)) > 0 ? date('H', strtotime($obj->late)) . 'H ' : '';
                                                        echo date('i', strtotime($obj->late)) > 0 ?  date('i', strtotime($obj->late)) . 'M' : '';
                                                    } ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    if ($obj->early_leaving) {
                                                        echo date('H', strtotime($obj->early_leaving)) > 0 ? date('H', strtotime($obj->early_leaving)) . 'H ' : '';
                                                        echo date('i', strtotime($obj->early_leaving)) > 0 ?   date('i', strtotime($obj->early_leaving)) . 'M' : '';
                                                    } ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    if ($obj->total) {
                                                        echo date('H', strtotime($obj->total)) > 0 ? date('H', strtotime($obj->total)) . 'H ' : '';
                                                        echo date('i', strtotime($obj->total)) > 0 ? date('i', strtotime($obj->total)) . 'M' : '';
                                                    } ?>
                                                </td>
                                                <td><?php echo get_attendance_badge($obj->attendance_status); ?></td>
                                                <td><?php echo $obj->remark; ?></td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'attendance', 'attendance')) { ?>
                                                        <button class="btn btn-xs btn-info" type="button" onclick="get_view_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter"><i class="fa fa-eye"></i></button>
                                                    <?php } ?>
                                                    <?php if (has_permission(EDIT, 'attendance', 'attendance')) { ?>
                                                        <a class="btn btn-xs btn-success" href="<?php echo site_url('attendance/edit/' . $obj->id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'attendance', 'attendance')) { ?>
                                                        <a class="btn btn-danger btn-xs" href="<?php echo site_url('attendance/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="12"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('attendance/get_single_attendance'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>

<script>
    function get_designation(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_designation'); ?>",
            data: {
                department_id: department_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#designation_id').html(response);
                }
            }
        });
    };
</script>