<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('attendance'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('import'); ?> <?php echo $this->lang->line('attendance'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-xl-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'attendance', 'attendance')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-clock-o font-30 mr-10"></i>
                            <?php echo $this->lang->line('import'); ?> <?php echo $this->lang->line('attendance'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(ADD, 'attendance', 'import')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('attendance/import/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('import'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    COMMING SOON
                </div>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->