<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Logs_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') != SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, PATHOLOGIST, RADIOLOGIST, NURSE, RECEPTIONIST, STAFF, MARKETING, PHARMACIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_attendance_logs_list($form_date, $to_date) {
        $this->db->select('L.*');
        $this->db->from('device_logs AS L');
        if ($form_date && $to_date) {
            $this->db->where("DATE(L.created_at) BETWEEN '$form_date' AND '$to_date'");
        }
        $this->db->order_by('L.id', 'DESC');
        return $this->db->get()->result();
    }

    public function get_single_employee($user_id) {
        $this->db->select('E.*, DP.name as department, D.name as designation, S.name as shift, U.device_id');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->join('departments AS DP', 'DP.id = E.department_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->join('shifts AS S', 'S.id = E.shift_id', 'left');
        $this->db->where('E.user_id', $user_id);
        return $this->db->get()->row();
    }
}
