<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Attendance.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Attendance
 * @description     : Manage all kind of attendance of the system.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : https://hms.sbitzone.com/      
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Attendance extends MY_Controller
{

    public $data = array();

    function __construct()
    {
        parent::__construct();
        $this->load->model('Attendance_Model', 'attendance', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Attendance Listing" user interface                 
     *                        
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function index()
    {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $shift_id = $this->input->get('shift_id');
            $type = $this->input->get('type');
            $attendance_status = $this->input->get('attendance_status');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $user_id = $this->input->get('user_id');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $keyword = trim($this->input->get('keyword'));

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('attendance?shift_id=' . $shift_id . '&type=' . $type . '&attendance_status=' . $attendance_status . '&date=' . $date . '&user_id=' . $user_id . '&department_id=' . $department_id . '&designation_id=' . $designation_id . '&keyword=' . $keyword);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->attendance->get_attendance_list($config['per_page'], $offset, $shift_id, $type, $attendance_status, $form_date, $to_date, $user_id, $department_id, $designation_id, $keyword, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['attendances'] = $this->attendance->get_attendance_list($config['per_page'], $offset, $shift_id, $type, $attendance_status, $form_date, $to_date, $user_id, $department_id, $designation_id, $keyword, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));

            $this->data['shift_id'] = $shift_id;
            $this->data['type'] = $type;
            $this->data['attendance_status'] = $attendance_status;
            $this->data['date'] = $date;
            $this->data['user_id'] = $user_id;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['keyword'] = $keyword;
        } else {
            $form_date = date('Y-m-d');
            $to_date = date('Y-m-d');
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->attendance->get_attendance_list($config['per_page'], $offset, null, null, null, $form_date, $to_date, null, null, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['attendances'] = $this->attendance->get_attendance_list($config['per_page'], $offset,  null, null, null, $form_date, $to_date, null, null, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['shifts'] = $this->attendance->get_list('shifts', array('status' => 1));
        $this->data['employees'] = $this->attendance->get_employee_list();
        $this->data['departments'] = $this->attendance->get_list('departments', array('status' => 1));
        $this->data['designations'] = $this->attendance->get_list('designations', array('status' => 1));
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_attendance') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('attendance/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new attendance" user interface
     *                    and process to store "attendances" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add()
    {

        check_permission(ADD);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('user_id', $this->lang->line('employee'), 'trim|required');
            $this->form_validation->set_rules('date', $this->lang->line('date'), 'trim|required');
            $this->form_validation->set_rules('attendance_status', $this->lang->line('status'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['user_id'] = $this->input->post('user_id');
                $employee = $this->attendance->get_single('employees', array('user_id' => $data['user_id']));
                $shift = $this->attendance->get_single('shifts', array('id' => $employee->shift_id));

                $data['shift_id'] = isset($employee) && $employee->shift_id > 0 ? $employee->shift_id : null;
                $data['is_manual'] = 1;
                $data['punch_type'] = 'finger';
                $data['date'] = $this->input->post('date') ? date('Y-m-d', strtotime($this->input->post('date'))) : date('Y-m-d');
                $data['clock_in'] = $this->input->post('clock_in') ? date('H:i:s', strtotime($this->input->post('clock_in'))) : null;
                $data['clock_out'] = $this->input->post('clock_out') ? date('H:i:s', strtotime($this->input->post('clock_out'))) : null;
                $data['attendance_status'] = $this->input->post('attendance_status');
                // Conditions
                if ($data['clock_in'] && isset($shift) && $shift->late_allow == 1 && strtotime($shift->late_time) < strtotime($data['clock_in'])) {
                    $in_time = new DateTime($shift->in_time);
                    $dev_in_time   = new DateTime($data['clock_in']);
                    $lateDiff  = $in_time->diff($dev_in_time);
                    $data['late'] = $lateDiff->format("%H:%I:%S");
                } else {
                    $data['late'] = null;
                }

                // Early Leave
                if ($data['clock_in'] && $data['clock_out'] && isset($shift) && $shift->early_out_allow == 0 && strtotime($shift->out_time) > strtotime($data['clock_out'])) {
                    $out_time = new DateTime($shift->out_time);
                    $dev_out_time   = new DateTime($data['clock_out']);
                    $earlyDiff  = $out_time->diff($dev_out_time);
                    $data['early_leaving'] = $earlyDiff->format("%H:%I:%S");
                } else {
                    $data['early_leaving'] = null;
                }

                // Overtime
                if (isset($shift) && strtotime($data['clock_out']) > strtotime($shift->out_time)) {
                    $overtime = new DateTime($shift->out_time);
                    $dev_overtime   = new DateTime($data['clock_out']);
                    $overtimeDiff  = $dev_overtime->diff($overtime);
                    $data['overtime'] = $overtimeDiff->format("%H:%I:%S");
                } else {
                    $data['overtime'] = null;
                }

                if (isset($shift) && $shift->out_next_day) {
                    $clock_in_date = (new DateTime($data['date']))->sub(new DateInterval('P1D'))->format('Y-m-d');
                    $clock_out_date   = new DateTime($data['date']);
                } else {
                    $clock_in_date   = new DateTime($data['date']);
                    $clock_out_date   = new DateTime($data['date']);
                }
                // Total Hour
                if (isset($shift) && $shift->out_next_day) {
                    $clock_in_date = (new DateTime($data['date']))->sub(new DateInterval('P1D'))->format('Y-m-d');
                    $intime = $clock_in_date . ' ' . $data['clock_in'];
                    $outtime = $data['date'] . ' ' . $data['clock_out'];
                } else {
                    $intime = $data['date'] . ' ' . $data['clock_in'];
                    $outtime = $data['date'] . ' ' . $data['clock_out'];
                }
                $clock_in = new DateTime($intime);
                $clock_out   = new DateTime($outtime);
                $totalDiff  = $clock_out->diff($clock_in);

                if ($data['clock_in'] && $data['clock_out']) {
                    $data['total'] = $totalDiff->format("%H:%I:%S");
                } else {
                    $data['total'] = null;
                }

                $data['remark'] = $this->input->post('remark');
                $data['status'] = 1;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $attendance = $this->attendance->get_single('attendances', array('user_id' => $data['user_id'], 'date' => $data['date']));

                if (isset($attendance) && $attendance) {
                    $this->attendance->update('attendances', $data, array('user_id' => $data['user_id'], 'date' => $data['date']));
                    create_log('Has been update a manual attendance : ' . $employee->name);
                    success($this->lang->line('update_success'));
                    redirect('attendance');
                } else {
                    $insert_id = $this->attendance->insert('attendances', $data);
                    if ($insert_id) {
                        create_log('Has been created a manual attendance : ' . $employee->name);
                        success($this->lang->line('insert_success'));
                        redirect('attendance');
                    } else {
                        error($this->lang->line('insert_failed'));
                        redirect('attendance/add');
                    }
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['employees'] = $this->attendance->get_employee_list();
        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('attendance') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('attendance/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load "Edit new attendance" user interface
     *                    and process to store "attendances" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function edit($id = NULL)
    {

        check_permission(EDIT);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('user_id', $this->lang->line('employee'), 'trim|required');
            $this->form_validation->set_rules('date', $this->lang->line('date'), 'trim|required');
            $this->form_validation->set_rules('attendance_status', $this->lang->line('status'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['user_id'] = $this->input->post('user_id');
                $employee = $this->attendance->get_single('employees', array('user_id' => $data['user_id']));
                $shift = $this->attendance->get_single('shifts', array('id' => $employee->shift_id));

                $data['shift_id'] = isset($employee) && $employee->shift_id > 0 ? $employee->shift_id : null;
                $data['is_manual'] = 1;
                $data['punch_type'] = 'finger';
                $data['date'] = $this->input->post('date') ? date('Y-m-d', strtotime($this->input->post('date'))) : date('Y-m-d');
                $data['clock_in'] = $this->input->post('clock_in') ? date('H:i:s', strtotime($this->input->post('clock_in'))) : null;
                $data['clock_out'] = $this->input->post('clock_out') ? date('H:i:s', strtotime($this->input->post('clock_out'))) : null;
                $data['attendance_status'] = $this->input->post('attendance_status');

                // Conditions
                if ($data['clock_in'] && isset($shift) && $shift->late_allow == 1 && strtotime($shift->late_time) < strtotime($data['clock_in'])) {
                    $in_time = new DateTime($shift->in_time);
                    $dev_in_time   = new DateTime($data['clock_in']);
                    $lateDiff  = $in_time->diff($dev_in_time);
                    $data['late'] = $lateDiff->format("%H:%I:%S");
                } else {
                    $data['late'] = null;
                }

                // Early Leave
                if ($data['clock_in'] && $data['clock_out'] && isset($shift) && $shift->early_out_allow == 0 && strtotime($shift->out_time) > strtotime($data['clock_out'])) {
                    $out_time = new DateTime($shift->out_time);
                    $dev_out_time   = new DateTime($data['clock_out']);
                    $earlyDiff  = $out_time->diff($dev_out_time);
                    $data['early_leaving'] = $earlyDiff->format("%H:%I:%S");
                } else {
                    $data['early_leaving'] = null;
                }

                // Overtime
                if (isset($shift) && strtotime($data['clock_out']) > strtotime($shift->out_time)) {
                    $overtime = new DateTime($shift->out_time);
                    $dev_overtime   = new DateTime($data['clock_out']);
                    $overtimeDiff  = $dev_overtime->diff($overtime);
                    $data['overtime'] = $overtimeDiff->format("%H:%I:%S");
                } else {
                    $data['overtime'] = null;
                }

                // Total Hour
                if (isset($shift) && $shift->out_next_day) {
                    $clock_in_date = (new DateTime($data['date']))->sub(new DateInterval('P1D'))->format('Y-m-d');
                    $intime = $clock_in_date . ' ' . $data['clock_in'];
                    $outtime = $data['date'] . ' ' . $data['clock_out'];
                } else {
                    $intime = $data['date'] . ' ' . $data['clock_in'];
                    $outtime = $data['date'] . ' ' . $data['clock_out'];
                }
                $clock_in = new DateTime($intime);
                $clock_out   = new DateTime($outtime);
                $totalDiff  = $clock_out->diff($clock_in);

                if ($data['clock_in'] && $data['clock_out']) {
                    $data['total'] = $totalDiff->format("%H:%I:%S");
                } else {
                    $data['total'] = null;
                }

                $data['remark'] = $this->input->post('remark');
                $data['status'] = 1;
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $updated = $this->attendance->update('attendances', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a attendance : ' . $employee->name);
                    success($this->lang->line('update_success'));
                    redirect('attendance');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('attendance/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['attendance'] = $this->attendance->get_single('attendances', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['attendance'] = $this->attendance->get_single('attendances', array('id' => $id));
                if (!$this->data['attendance']) {
                    redirect('attendance');
                }
            }
        }

        $this->data['employees'] = $this->attendance->get_employee_list();
        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('attendance') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('attendance/edit', $this->data);
    }


    /*     * ***************Function get_single_attendance**********************************
     * @type            : Function
     * @function name   : get_single_attendance
     * @description     : "Load single attendance information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_attendance()
    {
        $id = $this->input->post('id');
        $this->data['attendance'] = $this->attendance->get_single_attendance($id);
        echo $this->load->view('attendance/view', $this->data);
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "attendances" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null)
    {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('attendance');
        }

        $attendance = $this->attendance->get_single('attendances', array('id' => $id));
        if ($this->attendance->delete('attendances', array('id' => $id))) {
            create_log('Has been deleted a attendance : ' . $attendance->id);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }


    /*****************Function manual**********************************
     * @type            : Function
     * @function name   : manual
     * @description     : Load "Attendance Listing" user interface                 
     *                        
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function manual()
    {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $date = $this->input->get('date');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $user_id = $this->input->get('user_id');
            $shift_id = $this->input->get('shift_id');

            $this->data['attendances'] = $this->attendance->get_attendance_employee_list($department_id, $designation_id, $user_id, $shift_id);

            $this->data['date'] = $date;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['user_id'] = $user_id;
            $this->data['shift_id'] = $shift_id;
        }

        $this->data['departments'] = $this->attendance->get_list('departments', array('status' => 1));
        $this->data['designations'] = $this->attendance->get_list('designations', array('status' => 1));
        $this->data['employees'] = $this->attendance->get_employee_list();
        $this->data['shifts'] = $this->attendance->get_list('shifts', array('status' => 1));

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_attendance') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('attendance/manual', $this->data);
    }


    /*****************Function manual_attendance**********************************
     * @type            : Function
     * @function name   : manual_attendance
     * @description     : Load "Attendance Listing" user interface                 
     *                        
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function manual_attendance()
    {

        check_permission(ADD);

        if ($_POST) {
            if (!empty($_POST['employee_id'])) {
                foreach ($_POST['employee_id'] as $key => $value) {
                    $id = $value;
                    $data['user_id'] = $id;
                    $data['shift_id'] = $_POST['shift_id'][$value];
                    $data['is_manual'] = 1;
                    $data['punch_type'] = 'finger';
                    $data['date'] = date('Y-m-d', strtotime($_POST['date'][$value]));
                    $data['clock_in'] = $_POST['clock_in'][$value] ? date('H:i:s', strtotime($_POST['clock_in'][$value])) : null;
                    $data['clock_out'] = $_POST['clock_out'][$value] ? date('H:i:s', strtotime($_POST['clock_out'][$value])) : null;
                    $data['attendance_status'] = $_POST['attendance_status'][$value];
                    $data['remark'] = $_POST['remark'][$value];
                    $data['status'] = 1;

                    // Conditions
                    $shift =  $this->attendance->get_single('shifts', array('status' => 1, 'id' => $data['shift_id']));

                    if ($data['clock_in'] && isset($shift) &&  $shift->late_allow == 1 && strtotime($shift->late_time) < strtotime($data['clock_in'])) {
                        $in_time = new DateTime($shift->in_time);
                        $dev_in_time   = new DateTime($data['clock_in']);
                        $lateDiff  = $in_time->diff($dev_in_time);
                        $data['late'] = $lateDiff->format("%H:%I:%S");
                    } else {
                        $data['late'] = null;
                    }

                    // Early Leave
                    if ($data['clock_in'] && $data['clock_out'] && isset($shift) &&  $shift->early_out_allow == 0 && strtotime($shift->out_time) > strtotime($data['clock_out'])) {
                        $out_time = new DateTime($shift->out_time);
                        $dev_out_time   = new DateTime($data['clock_out']);
                        $earlyDiff  = $out_time->diff($dev_out_time);
                        $data['early_leaving'] = $earlyDiff->format("%H:%I:%S");
                    } else {
                        $data['early_leaving'] = null;
                    }

                    // Overtime
                    if (isset($shift) && strtotime($data['clock_out']) > strtotime($shift->out_time)) {
                        $overtime = new DateTime($shift->out_time);
                        $dev_overtime   = new DateTime($data['clock_out']);
                        $overtimeDiff  = $dev_overtime->diff($overtime);
                        $data['overtime'] = $overtimeDiff->format("%H:%I:%S");
                    } else {
                        $data['overtime'] = null;
                    }
                    // Total Hour
                    if (isset($shift) && $shift->out_next_day) {
                        $clock_in_date = (new DateTime($data['date']))->sub(new DateInterval('P1D'))->format('Y-m-d');
                        $intime = $clock_in_date . ' ' . $data['clock_in'];
                        $outtime = $data['date'] . ' ' . $data['clock_out'];
                    } else {
                        $intime = $data['date'] . ' ' . $data['clock_in'];
                        $outtime = $data['date'] . ' ' . $data['clock_out'];
                    }
                    $clock_in = new DateTime($intime);
                    $clock_out   = new DateTime($outtime);
                    $totalDiff  = $clock_out->diff($clock_in);

                    if ($data['clock_in'] && $data['clock_out']) {
                        $data['total'] = $totalDiff->format("%H:%I:%S");
                    } else {
                        $data['total'] = null;
                    }
                    $attendance = $this->attendance->get_single('attendances', array('user_id' => $id, 'date' => $data['date']));
                    if (isset($attendance) && $attendance) {
                        $data['modified_at'] = date('Y-m-d H:i:s');
                        $data['modified_by'] = logged_in_user_id();
                        $this->attendance->update('attendances', $data, array('user_id' => $id, 'date' => $data['date']));
                    } else {
                        $data['created_at'] = date('Y-m-d H:i:s');
                        $data['created_by'] = logged_in_user_id();
                        $this->attendance->insert('attendances', $data);
                    }
                }
                create_log('Has been created an attendance for multiple data');
                success($this->lang->line('update_success'));
                redirect('attendance');
            }
        }
    }

    /*****************Function not_in_office**********************************
     * @type            : Function
     * @function name   : not_in_office
     * @description     : Load "Attendance Listing" user interface                 
     *                        
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function not_in_office()
    {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $shift_id = $this->input->get('shift_id');
            $type = $this->input->get('type');
            $attendance_status = $this->input->get('attendance_status');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $user_id = $this->input->get('user_id');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $keyword = trim($this->input->get('keyword'));

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('attendance/not_in_office?shift_id=' . $shift_id . '&type=' . $type . '&attendance_status=' . $attendance_status . '&date=' . $date . '&user_id=' . $user_id . '&department_id=' . $department_id . '&designation_id=' . $designation_id . '&keyword=' . $keyword);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->attendance->get_not_in_office_attendance_list($config['per_page'], $offset, $shift_id, $type, $attendance_status, $form_date, $to_date, $user_id, $department_id, $designation_id, $keyword, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['attendances'] = $this->attendance->get_not_in_office_attendance_list($config['per_page'], $offset, $shift_id, $type, $attendance_status, $form_date, $to_date, $user_id, $department_id, $designation_id, $keyword, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));

            $this->data['shift_id'] = $shift_id;
            $this->data['type'] = $type;
            $this->data['attendance_status'] = $attendance_status;
            $this->data['date'] = $date;
            $this->data['user_id'] = $user_id;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['keyword'] = $keyword;
        } else {
            $form_date = date('Y-m-d');
            $to_date = date('Y-m-d');
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->attendance->get_not_in_office_attendance_list($config['per_page'], $offset, null, null, null, $form_date, $to_date, null, null, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['attendances'] = $this->attendance->get_not_in_office_attendance_list($config['per_page'], $offset,  null, null, null, $form_date, $to_date, null, null, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['shifts'] = $this->attendance->get_list('shifts', array('status' => 1));
        $this->data['employees'] = $this->attendance->get_employee_list();
        $this->data['departments'] = $this->attendance->get_list('departments', array('status' => 1));
        $this->data['designations'] = $this->attendance->get_list('designations', array('status' => 1));

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_attendance') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('attendance/not-in-office', $this->data);
    }
}
