<div class="table-wrap">
    <div class="table-responsive">
        <table class="table table-sm text-white">
            <tbody>
                <tr>
                    <td class="w-20"><?php echo $this->lang->line('name'); ?></td>
                    <td><?php echo $payment->patient_name; ?></td>
                    <td class="w-20"><?php echo $this->lang->line('phone'); ?></td>
                    <td><?php echo $payment->phone; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('gender'); ?></td>
                    <td><?php echo $this->lang->line($payment->gender); ?></td>
                    <td><?php echo $this->lang->line('address'); ?></td>
                    <td><?php echo $payment->address; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('doctor'); ?></td>
                    <td><?php echo $payment->doctor; ?></td>
                    <td><?php echo $this->lang->line('reference'); ?></td>
                    <td><?php echo $payment->reference; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('commission'); ?> <?php echo $this->lang->line('amount'); ?></td>
                    <td><?php echo $payment->commission_amount; ?></td>
                    <td><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('amount'); ?></td>
                    <td><?php echo $payment->payable_amount; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d M, Y h:ia', strtotime($payment->date)); ?></td>
                    <td><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('status'); ?></td>
                    <td>
                        <?php if ($payment->paid_status == 'paid') { ?>
                            <span class="badge badge-success"><?php echo $this->lang->line('paid'); ?></span>
                        <?php } else { ?>
                            <span class="badge badge-danger"><?php echo $this->lang->line('unpaid'); ?></span>
                        <?php } ?>
                    </td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('created_by'); ?></td>
                    <td><?php echo $payment->created_by; ?></td>
                    <td><?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d M, Y h:ia', strtotime($payment->created_at)); ?></td>
                </tr>
                <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
                    <tr>
                        <td><?php echo $this->lang->line('modified_by'); ?></td>
                        <td><?php echo $payment->modified_by; ?></td>
                        <td><?php echo $this->lang->line('date'); ?></td>
                        <td><?php echo $payment->modified_by ? date('d F, Y h:i A', strtotime($appointment->modified_at)) : ''; ?>
                        </td>
                    </tr>
                <?php } ?>
                <tr>
                    <td><?php echo $this->lang->line('remark'); ?></td>
                    <td colspan="3"><?php echo $payment->note; ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>