<!DOCTYPE html>
<html>

<head>
    <title>Print Bill</title>

    <style>
        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 12px;
        }

        .page {
            width: 58mm;
            margin: 0 auto;
            padding: 0;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .patient_table {
            width: 100%;
        }

        .patient_table tbody td {
            color: #000;
            padding: 1px;
            vertical-align: middle;
            border: 1px dashed #ccc;
            font-size: 12px;
        }

        p {
            margin: 0;
            padding: 0;
            text-align: center;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div class="page">
        <table class="table patient_table">
            <tbody>
                <tr>
                    <td align="center" colspan="2" style="border: none;">
                        <b><u>SMH</u></b>
                    </td>
                </tr>
                <tr>
                    <td colspan="2"><?php echo date('d M, Y h:ia', strtotime($patient->date)); ?></td>
                </tr>
                <tr>
                    <td colspan="2"><?php echo $patient->custom_invoice_id; ?></td>
                </tr>
                <tr>
                    <td><b>Patient ID:</b></td>
                    <td><?php echo $patient->patient_unique_id; ?></td>
                </tr>
                <tr>
                    <td><b>Patient Name:</b></td>
                    <td><?php echo $patient->patient_name; ?></td>
                </tr>
                <tr>
                    <td colspan="2">
                        <b>Anesthetists:</b>
                        <?php echo $patient->doctor; ?>
                    </td>
                </tr>
                <tr>
                    <td><b>Amount:</b></td>
                    <td><?php echo number_format(($patient->commission_amount), 2); ?></td>
                </tr>
                <tr>
                    <td><b>Payable Amount:</b></td>
                    <td><?php echo number_format($patient->payable_amount, 2); ?></td>
                </tr>
            </tbody>
        </table>
        <p style="text-align: left; font-size: 12px; margin-bottom: 10px; margin-top: 10px;">Created By: <?php echo $patient->created_by; ?></p>
    </div>
</body>

</html>