<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('schedule'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_schedule'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'doctor', 'schedule')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-clock-o font-30 mr-10"></i>
                            <?php echo $this->lang->line('schedule'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php echo form_open_multipart(site_url('doctor/schedule'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>

                    <?php if (has_permission(ADD, 'doctor', 'schedule')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('doctor/schedule/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('schedule'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('doctor'); ?></th>
                                        <th><?php echo $this->lang->line('day'); ?></th>
                                        <th><?php echo $this->lang->line('start_time'); ?></th>
                                        <th><?php echo $this->lang->line('end_time'); ?></th>
                                        <th><?php echo $this->lang->line('per_patient_time'); ?></th>
                                        <th><?php echo $this->lang->line('serial_visibility'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th><?php echo $this->lang->line('sort_by'); ?></th>
                                        <th class="w-15"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($schedules) && !empty($schedules)) { ?>
                                        <?php foreach ($schedules as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->doctor; ?></td>
                                                <td><?php echo  $this->lang->line($obj->day); ?></td>
                                                <td><?php echo date($this->global_setting->time_format, strtotime($obj->start_time)); ?></td>
                                                <td><?php echo date($this->global_setting->time_format, strtotime($obj->end_time)); ?></td>
                                                <td><?php echo $obj->per_patient_time; ?> <?php echo $this->lang->line('minute'); ?></td>
                                                <td><?php echo $obj->serial_visibility; ?></td>
                                                <td><?php echo $obj->status ? '<span class="badge badge-success">' . $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('in_active') . '</span>'; ?></td>
                                                <td><?php echo $obj->sort_by; ?></td>
                                                <td>
                                                    <?php if (has_permission(EDIT, 'doctor', 'schedule')) { ?>
                                                        <a class="btn btn-xs btn-success" href="<?php echo site_url('doctor/schedule/edit/' . $obj->id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'doctor', 'schedule')) { ?>
                                                        <a class="btn btn-xs btn-danger" href="<?php echo site_url('doctor/schedule/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="10"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->