<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('unit'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-balance-scale"></i></span>
            <?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('unit'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('diagnostic/template/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'diagnostic', 'template')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-balance-scale font-30 mr-10"></i>
                            <?php echo $this->lang->line('unit'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(ADD, 'diagnostic', 'template')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('diagnostic/template/unit_add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('unit'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line('sl_no'); ?></th>
                                    <th><?php echo $this->lang->line('unit_name'); ?></th>
                                    
                                    <th><?php echo $this->lang->line('status'); ?></th>
                                    <th><?php echo $this->lang->line('action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $sl = 1;
                                if (isset($units) && !empty($units)) {
                                    foreach ($units as $obj) {
                                ?>
                                        <tr>
                                            <td><?php echo $sl++; ?></td>
                                            <td><?php echo $obj->unit_name; ?></td>
                                            <td>
                                                <?php if ($obj->status == 1) { ?>
                                                    <span class="badge badge-success"><?php echo $this->lang->line('active'); ?></span>
                                                <?php } else { ?>
                                                    <span class="badge badge-danger"><?php echo $this->lang->line('inactive'); ?></span>
                                                <?php } ?>
                                            </td>
                                            <td>
                                                <?php if (has_permission(EDIT, 'diagnostic', 'template')) { ?>
                                                    <a href="<?php echo site_url('diagnostic/template/unit_edit/' . $obj->id); ?>" class="btn btn-xs btn-info">
                                                        <i class="fa fa-edit"></i>
                                                    </a>
                                                <?php } ?>
                                                <?php if (has_permission(DELETE, 'diagnostic', 'template')) { ?>
                                                    <a href="<?php echo site_url('diagnostic/template/unit_delete/' . $obj->id); ?>" class="btn btn-xs btn-danger" onclick="return confirm('<?php echo $this->lang->line('are_you_sure'); ?>?')">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                <?php } ?>
                                            </td>
                                        </tr>
                                <?php
                                    }
                                } else {
                                ?>
                                    <tr>
                                        <td colspan="4" class="text-center"><?php echo $this->lang->line('no_data_found'); ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->