<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item"><a href="<?php echo site_url('diagnostic/template/unit'); ?>"><?php echo $this->lang->line('unit'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('unit'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-edit"></i></span>
            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('unit'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('diagnostic/template/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'diagnostic', 'template')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-edit font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('unit'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'diagnostic', 'template')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('diagnostic/template/unit'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('unit'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open(site_url('diagnostic/template/unit_edit/' . $unit->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <input type="hidden" name="id" value="<?php echo $unit->id; ?>" />
                    <div class="form-row">
                        <div class="col-md-8 mb-10">
                            <label for="unit_name"><?php echo $this->lang->line('unit_name'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="unit_name" id="unit_name" value="<?php echo isset($unit->unit_name) ? $unit->unit_name : ''; ?>" placeholder="<?php echo $this->lang->line('unit_name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <?php echo form_error('unit_name'); ?>
                        </div>
                        <div class="col-md-4 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" <?php echo isset($unit->status) && $unit->status ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('diagnostic/template/unit'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<script type="text/javascript">
    $('#edit').on('submit', function () {
        var unit_name = $('#unit_name').val();
        if (unit_name === '') {
            toastr.error('<?php echo $this->lang->line('unit_name_required'); ?>');
            $('#unit_name').focus();
            return false;
        }
        return true;
    });
</script> 