<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('users'); ?> <?php echo $this->lang->line('credential'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('users'); ?> <?php echo $this->lang->line('credential'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <h6 class="card-header d-flex align-items-center">
                        <i class="fa fa-unlock-alt font-30 mr-10"></i>
                        <?php echo $this->lang->line('user'); ?> <?php echo $this->lang->line('credential'); ?>
                    </h6>
                    <div class="align-items-center">
                        <a href="<?php echo site_url('dashboard'); ?>" class="btn btn-xs btn-primary">
                            <i class="fa fa-dashboard"></i>
                            <?php echo $this->lang->line('dashboard'); ?>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('setting/usercredential'), array('method' => 'get', 'name' => 'usercredential', 'id' => 'usercredential', 'class' => 'form-inline needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                    <div class="form-row align-items-center">
                        <div class="col-auto">
                            <select class="form-control custom-select" name="role_id" id="role_id" onchange="get_user_by_role(this.value, '', '');">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($roles as $obj) { ?>
                                    <?php if ($this->session->userdata('role_id') != SUPER_ADMIN) { ?>
                                        <?php if (in_array($obj->id, array(SUPER_ADMIN))) {
                                            continue;
                                        } ?>
                                    <?php } ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($role_id) && $role_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-auto">
                            <select class="form-control custom-select" name="user_id" id="user_id">
                                <option value=""><?php echo $this->lang->line('select'); ?></option>
                            </select>
                        </div>
                        <div class="col-auto">
                            <button type="submit" class="btn btn-primary mb-2"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0 mt-30">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('photo'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('phone'); ?></th>
                                        <th><?php echo $this->lang->line('username'); ?></th>
                                        <th><?php echo $this->lang->line('password'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($users) && !empty($users)) {  ?>
                                        <?php foreach ($users as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count;  ?></td>
                                                <td>
                                                    <div class="avatar mr-10">
                                                        <?php if ($obj->photo) { ?>
                                                            <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>employee-photo/<?php echo $obj->photo; ?>" alt="<?php echo $obj->name; ?>">
                                                        <?php } elseif ($obj->gender == 'male') { ?>
                                                            <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>male.png" alt="male" />
                                                        <?php } else { ?>
                                                            <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>female.png" alt="female" />
                                                        <?php } ?>
                                                    </div>
                                                </td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo $obj->phone; ?></td>
                                                <td><?php echo $obj->username; ?></td>
                                                <td><?php echo base64_decode($obj->temp_password); ?></td>
                                                <td><?php echo $obj->status ? '<span class="btn btn-success btn-xs">' . $this->lang->line('active') . '</span>' : '<span class="btn btn-success btn-xs">' . $this->lang->line('in_active') . '</span>'; ?></td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<script>
    <?php if (isset($role_id)) { ?>
        get_user_by_role('<?php echo $role_id;  ?>', '<?php echo $user_id; ?>');
    <?php } ?>

    function get_user_by_role(role_id, user_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_user_by_role'); ?>",
            data: {
                role_id: role_id,
                user_id: user_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#user_id').html(response);
                }
            }
        });
    }
</script>