<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Role_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_role_list($limit, $offset, $search, $count) {
        $this->db->select('R.*');
        $this->db->from('roles AS R');
        if ($search) {
            $this->db->like('R.name', $search);
            $this->db->or_like('R.slug', $search);
            $this->db->or_like('R.note', $search);
            $this->db->or_like('R.created_at', $search);
        }
        $this->db->order_by('R.id', 'ASC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check($name, $id = null) {

        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('roles')->num_rows();
    }
}
