<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Emailsetting.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Emailsetting
 * @description     : Manage application Emailsetting.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Emailsetting extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Setting_Model', 'setting', true);
    }

    /*     * ***************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Email Setting" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function index() {

        check_permission(VIEW);

        $this->data['email_setting'] = $this->setting->get_single('email_settings', array('status' => 1));

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('email') . ' ' . $this->lang->line('setting') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('email_setting/index', $this->data);
    }

    /*     * ***************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "New General Settings" user interface
     *                    and process to store "General Settings" into database
     *                    for the first time settings
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function add() {

        check_permission(ADD);

        if ($_POST) {
            $this->_prepare_setting_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_setting_data();

                $insert_id = $this->setting->insert('email_settings', $data);
                if ($insert_id) {
                    create_log('Has been created email setting');
                    success($this->lang->line('insert_success'));
                    redirect('setting/emailsetting');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('setting/emailsetting/add');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->layout->title($this->lang->line('email') . ' ' . $this->lang->line('setting') . ' | ' . $this->data['setting']->brand_title);
        $this->layout->view('emailsetting/index', $this->data);
    }

    /*     * ***************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Email Settings" user interface
     *                    with populate "Email Settings" value
     *                    and process to update "Email Settings" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */

    public function edit($id = null) {

        check_permission(EDIT);

        if ($_POST) {
            $this->_prepare_setting_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_setting_data();
                $updated = $this->setting->update('email_settings', $data, array('id' => $this->input->post('id')));

                if ($updated) {
                    create_log('Has been updated global setting');
                    success($this->lang->line('update_success'));
                    redirect('setting/emailsetting');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('setting/emailsetting/edit/' . $this->input->post('id'));
                }
            }
        }

        $this->layout->title($this->lang->line('email') . ' ' . $this->lang->line('setting') . ' | ' . $this->data['setting']->brand_title ? $this->data['setting']->brand_title : TITLE);
        $this->layout->view('setting/index', $this->data);
    }

    /*     * ***************Function _prepare_setting_validation**********************************
     * @type            : Function
     * @function name   : _prepare_setting_validation
     * @description     : Process "Email Settings" user input data validation
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    private function _prepare_setting_validation() {

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');

        $this->form_validation->set_rules('mail_protocol', $this->lang->line('email') . ' ' . $this->lang->line('protocol'), 'trim|required');

        if ($this->input->post('mail_protocol') == 'smtp') {
            $this->form_validation->set_rules('smtp_host', $this->lang->line('smtp') . ' ' . $this->lang->line('host'), 'trim|required');
            $this->form_validation->set_rules('smtp_port', $this->lang->line('smtp') . ' ' . $this->lang->line('port'), 'trim|required');
            $this->form_validation->set_rules('smtp_user', $this->lang->line('smtp') . ' ' . $this->lang->line('username'), 'trim|required');
            $this->form_validation->set_rules('smtp_pass', $this->lang->line('smtp') . ' ' . $this->lang->line('password'), 'trim|required');
            $this->form_validation->set_rules('smtp_timeout', $this->lang->line('smtp') . ' ' . $this->lang->line('time_out'), 'trim');
            $this->form_validation->set_rules('smtp_crypto', $this->lang->line('smtp') . ' ' . $this->lang->line('security'), 'trim');
        }
        $this->form_validation->set_rules('mail_type', $this->lang->line('email') . ' ' . $this->lang->line('type'), 'trim');
        $this->form_validation->set_rules('char_set', $this->lang->line('email') . ' ' . $this->lang->line('char_set'), 'trim');
        $this->form_validation->set_rules('priority', $this->lang->line('email') . ' ' . $this->lang->line('priority'), 'trim');
        $this->form_validation->set_rules('from_name', $this->lang->line('email') . ' ' . $this->lang->line('from') . ' ' . $this->lang->line('name'), 'trim');
        $this->form_validation->set_rules('from_address', $this->lang->line('email') . ' ' . $this->lang->line('from') . ' ' . $this->lang->line('address'), 'trim');
    }

    /*     * ***************Function _get_posted_setting_data**********************************
     * @type            : Function
     * @function name   : _get_posted_setting_data
     * @description     : Prepare "Email Settings" user input data to save into database
     *
     * @param           : null
     * @return          : $data array(); value
     * ********************************************************** */

    private function _get_posted_setting_data() {

        $items = array();

        $items[] = 'mail_protocol';
        $items[] = 'smtp_host';
        $items[] = 'smtp_port';
        $items[] = 'smtp_timeout';
        $items[] = 'smtp_user';
        $items[] = 'smtp_pass';
        $items[] = 'smtp_crypto';
        $items[] = 'mail_type';
        $items[] = 'char_set';
        $items[] = 'priority';
        $items[] = 'from_name';
        $items[] = 'from_address';

        $data = elements($items, $_POST);


        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {
            $data['status'] = 1;
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
        }

        return $data;
    }
}
