<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'report', 'appointment')) { ?>
                <a href="<?php echo site_url('report/appointment'); ?>" class="btn btn-primary btn-sm mr-15"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'report', 'opd')) { ?>
                <a href="<?php echo site_url('report/opd'); ?>" class="btn btn-success btn-sm mr-15"><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <?php echo form_open_multipart(site_url('report/payment'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="name"><?php echo $this->lang->line('invoice'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="invoice_type" id="invoice_type" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <option value="all" <?php echo isset($invoice_type) && $invoice_type == 'all' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('all'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="opd" <?php echo isset($invoice_type) && $invoice_type == 'opd' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="ipd" <?php echo isset($invoice_type) && $invoice_type == 'ipd' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="investigation" <?php echo isset($invoice_type) && $invoice_type == 'investigation' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('investigations'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="surgeon" <?php echo isset($invoice_type) && $invoice_type == 'surgeon' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('surgeon'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="anesthesia" <?php echo isset($invoice_type) && $invoice_type == 'anesthesia' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('anesthesia'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="assistant" <?php echo isset($invoice_type) && $invoice_type == 'assistant' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('assistant'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="consultant" <?php echo isset($invoice_type) && $invoice_type == 'consultant' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('consultant'); ?> <?php echo $this->lang->line('payment'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="range"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                            <select class="form-control custom-select select2" name="reference_id" id="reference_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                                <?php foreach ($references as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_id) && $reference_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
        <?php if (isset($payments) && !empty($payments)) { ?>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="hk-pg-title">
                            <i class="fa fa-h-square"></i>
                            <?php echo $this->lang->line($invoice_type); ?> <?php echo $this->lang->line('report'); ?>
                        </h4>
                        <div class="button-list mt-0">
                            <a href="<?php echo site_url('report/payment/pdf/?invoice_type=' . $invoice_type . '&keyword=' . $keyword . '&date=' . $date . '&doctor_id=' . $doctor_id . '&reference_id=' . $reference_id . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs"><i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?></a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <?php if ($invoice_type == 'all') { ?>
                                            <tr>
                                                <th><?php echo $this->lang->line('sl_no'); ?></th>
                                                <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                                <th><?php echo $this->lang->line('type'); ?></th>
                                                <th><?php echo $this->lang->line('patient_id'); ?></th>
                                                <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                                <th><?php echo $this->lang->line('payment_to'); ?></th>
                                                <th><?php echo $this->lang->line('amount'); ?></th>
                                                <th><?php echo $this->lang->line('payment'); ?></th>
                                                <th><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?></th>
                                                <th><?php echo $this->lang->line('created_by'); ?></th>
                                            </tr>
                                        <?php } else { ?>
                                            <tr>
                                                <th><?php echo $this->lang->line('sl_no'); ?></th>
                                                <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                                    <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                                <?php } ?>
                                                <th><?php echo $this->lang->line('date'); ?></th>
                                                <th><?php echo $this->lang->line('patient_id'); ?></th>
                                                <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                                <th>P.<?php echo $this->lang->line('mobile'); ?></th>
                                                <?php if ($invoice_type != 'assistant') { ?>
                                                    <th><?php echo $this->lang->line('doctor'); ?></th>
                                                <?php } else { ?>
                                                    <th><?php echo $this->lang->line('assistant'); ?></th>
                                                <?php } ?>
                                                <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                                    <th><?php echo $this->lang->line('reference'); ?></th>
                                                <?php } ?>
                                              	<?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                                    <th>D.<?php echo $this->lang->line('mobile'); ?></th>
                                                <?php } ?>
                                                <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                                    <th><?php echo $this->lang->line('commission'); ?></th>
                                                <?php } else { ?>
                                                    <th><?php echo $this->lang->line('charge'); ?></th>
                                                <?php } ?>
                                                <th><?php echo $this->lang->line('payment'); ?></th>
                                                <th><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?></th>
                                                <th><?php echo $this->lang->line('created_by'); ?></th>
                                            </tr>
                                        <?php } ?>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        $total_commission = 0;
                                        $total_payment = 0;
                                        foreach ($payments as $obj) {
                                            $total_commission +=  $obj->commission_amount;
                                            $total_payment +=  $obj->payable_amount;
                                        ?>
                                            <?php if ($invoice_type == 'all') { ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td><?php echo $this->lang->line($obj->invoice_type); ?></td>
                                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                                    <td><?php echo $obj->patient; ?></td>
                                                    <td>
                                                        <?php if ($obj->doctor) {
                                                            echo $obj->doctor;
                                                        } elseif ($obj->anesthetist) {
                                                            echo $obj->anesthetist;
                                                        } else {
                                                            echo $obj->assistant;
                                                        }
                                                        ?>
                                                    </td>
                                                    <td><?php echo $obj->commission_amount; ?></td>
                                                    <td><?php echo $obj->payable_amount; ?></td>
                                                    <td><?php echo date('M d, Y h:iA', strtotime($obj->date)); ?></td>
                                                    <td><?php echo $obj->created_by; ?></td>
                                                </tr>
                                            <?php } else { ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                                        <td> <?php echo $obj->custom_invoice_id; ?></td>
                                                    <?php } ?>
                                                    <td><?php echo  date('M d, Y h:iA', strtotime($obj->bill_date)); ?></td>
                                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                                    <td><?php echo $obj->patient; ?></td>
                                                    <td><?php echo $obj->p_phone; ?></td>
                                                    <td><?php echo $obj->doctor; ?></td>
                                                    <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                                        <td><?php echo $obj->reference; ?></td>
                                                    <?php } ?>
                                                  	<?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                                        <td><?php echo $obj->reference_phone; ?></td>
                                                    <?php } ?>
                                                    <td><?php echo $obj->commission_amount; ?></td>
                                                    <td><?php echo $obj->payable_amount; ?></td>
                                                    <td><?php echo date('M d, Y h:iA', strtotime($obj->date)); ?></td>
                                                    <td><?php echo $obj->created_by; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                        <?php if ($invoice_type == 'all') { ?>
                                            <tr class="bg-transparent">
                                                <td colspan="8" class="text-right text-light border-top-0">Total Amount</td>
                                                <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_commission, 2); ?></td>
                                            </tr>
                                            <tr class="bg-transparent">
                                                <td colspan="8" class="text-right text-light border-top-0">Total Payment</td>
                                                <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_payment, 2); ?></td>
                                            </tr>
                                        <?php } else { ?>
                                            <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                                <tr class="bg-transparent">
                                                    <td colspan="9" class="text-right text-light border-top-0">Total Commission</td>
                                                    <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_commission, 2); ?></td>
                                                </tr>
                                                <tr class="bg-transparent">
                                                    <td colspan="9" class="text-right text-light border-top-0">Total Payment</td>
                                                    <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_payment, 2); ?></td>
                                                </tr>
                                            <?php } else { ?>
                                                <tr class="bg-transparent">
                                                    <td colspan="7" class="text-right text-light border-top-0">Total Charge</td>
                                                    <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_commission, 2); ?></td>
                                                </tr>
                                                <tr class="bg-transparent">
                                                    <td colspan="7" class="text-right text-light border-top-0">Total Payment</td>
                                                    <td colspan="2" class="text-right border-top-0"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_payment, 2); ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="border-bottom border-1">
                                        <?php if ($invoice_type == 'all') { ?>
                                            <tr>
                                                <th colspan="8" class="text-right font-weight-600">Total Payable Amount</th>
                                                <th colspan="2" class="text-right font-weight-600"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_payment, 2); ?></th>
                                            </tr>
                                        <?php } else { ?>
                                            <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                                <tr>
                                                    <th colspan="9" class="text-right font-weight-600">Total Payable Amount</th>
                                                    <th colspan="2" class="text-right font-weight-600"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_payment, 2); ?></th>
                                                </tr>
                                            <?php } else { ?>
                                                <tr>
                                                    <th colspan="7" class="text-right font-weight-600">Total Payable Amount</th>
                                                    <th colspan="2" class="text-right font-weight-600"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_payment, 2); ?></th>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>