<!DOCTYPE html>
<html>

<head>
    <title>Hospital Summery</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tfoot td {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">
                HOSPITAL SUMMERY REPORT<br>
                <small>
                    <?php echo date('M d, Y', strtotime($form_date)); ?> -
                    <?php echo date('M d, Y', strtotime($to_date)); ?>
                </small>
            </h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%" align="left">
                                <?php if (isset($reference_id) && !empty($reference_id)) { ?>
                                    <b>Reference:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $reference->name; ?>, <?php echo $reference->phone; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Report:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="30%" align="right">
                                <b>Print Date:</b>
                                <span style="font-size: 12px;"><?php echo date('M d, Y h:ia'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th>SL</th>
                            <th class="bg-success text-white text-center text-uppercase">Date</th>
                            <th class="bg-success text-white text-center text-uppercase">IPD</th>
                            <th class="bg-success text-white text-center text-uppercase">Diagnostic</th>
                            <th class="bg-success text-white text-center text-uppercase">OPD</th>
                            <th class="bg-success text-white text-center text-uppercase">Income</th>
                            <th class="bg-success text-white text-center text-uppercase">Total</th>
                            <th class="bg-danger text-white text-center text-uppercase">IPD</th>
                            <th class="bg-danger text-white text-center text-uppercase">Diagnostic</th>
                            <th class="bg-danger text-white text-center text-uppercase">Surgeon</th>
                            <th class="bg-danger text-white text-center text-uppercase">Anesth.</th>
                            <th class="bg-danger text-white text-center text-uppercase">Assist.</th>
                            <th class="bg-danger text-white text-center text-uppercase">Expense</th>
                            <th class="bg-danger text-white text-center text-uppercase">Total</th>
                            <th class="bg-success text-white text-center text-uppercase">Total</th>
                        </tr>

                    </thead>
                    <tbody>
                                        <?php
                                        $count = 1;
                          				$total_ipd_income=0;
                          				$total_diagnostic_income=0;
                                        $total_opd_income=0;
                          				$total_income=0;
                          				$in_total_income=0;
                          				$total_ipd_expense=0;
                          				$total_diagnostic_expense=0;
                          				$total_surgeon_expense=0;
                          				$total_anesthetist_expense=0;
                          				$total_assistant_expense=0;
                          				$total_expense=0;
                          				$in_total_expense=0;
                          				$all_total=0;
                                        foreach ($date_range as $obj) { 
                                      	$total_ipd_income += $obj['ipd_income'];
                                        $total_diagnostic_income += $obj['diagnostic_income'];
                                        $total_opd_income += $obj['opd_income'];
                          				$total_income += $obj['income'];
                          				$in_total_income += $obj['total_income'];
                          				$total_ipd_expense += $obj['ipd_expense'];
                          				$total_diagnostic_expense += $obj['diagnostic_expense'];
                          				$total_surgeon_expense += $obj['surgeon_expense'];
                          				$total_anesthetist_expense += $obj['anesthetist_expense'];
                          				$total_assistant_expense += $obj['assistant_expense'];
                          				$total_expense += $obj['expense'];
                          				$in_total_expense += $obj['total_expense'];
                          				$all_total += $obj['total'];
                                      ?>                                      		
                                            <tr>
                                                <td><?php echo $count++; ?></td>
                                                <td><?php echo $obj['date']; ?></td>
                                                <td><?php echo number_format($obj['ipd_income'],0 ); ?></td>
                                                <td><?php echo number_format($obj['diagnostic_income'],0 ); ?></td>
                                                <td><?php echo number_format($obj['opd_income'],0 ); ?></td>
                                                <td><?php echo number_format($obj['income'],0 ); ?></td>
                                                <td><?php echo number_format($obj['total_income'],0 ); ?></td>
                                                <td><?php echo number_format($obj['ipd_expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['diagnostic_expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['surgeon_expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['anesthetist_expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['assistant_expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['total_expense'],0 ); ?></td>
                                                <td><?php echo number_format($obj['total'],0 ); ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                      <tr>
                                        <td colspan="2">Total</td>
                                        <td><?php echo $total_ipd_income; ?></td>
                                        <td><?php echo $total_diagnostic_income; ?></td>
                                        <td><?php echo $total_opd_income; ?></td>
                                        <td><?php echo $total_income; ?></td>
                                        <td><?php echo $in_total_income; ?></td>
                                        <td><?php echo $total_ipd_expense; ?></td>
                                        <td><?php echo $total_diagnostic_expense; ?></td>
                                        <td><?php echo $total_surgeon_expense; ?></td>
                                        <td><?php echo $total_anesthetist_expense; ?></td>
                                        <td><?php echo $total_assistant_expense; ?></td>
                                        <td><?php echo $total_expense; ?></td>
                                        <td><?php echo $in_total_expense; ?></td>
                                        <td><?php echo $all_total; ?></td>
                                      </tr>
                                    </tfoot>
                </table>
            </div>
            <!-- Content End -->

            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Printed By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>