<!DOCTYPE html>
<html>

<head>
    <title>Hospital Credit</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tfoot th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">HOSPITAL CREDIT REPORT</h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <?php if (isset($reference_id) && !empty($reference_id)) { ?>
                                    <b>Reference:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $reference->name; ?>, <?php echo $reference->phone; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Report:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="20%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('M d, Y h:ia'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th colspan="3"><?php echo $this->lang->line('income'); ?></th>
                            <th colspan="3"><?php echo $this->lang->line('expense'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td width="25%"><?php echo $this->lang->line('department'); ?></td>
                            <td width="10%"><?php echo $this->lang->line('quantity'); ?></td>
                            <td width="15%"><?php echo $this->lang->line('amount'); ?></td>
                            <td width="25%"><?php echo $this->lang->line('department'); ?></td>
                            <td width="10%"><?php echo $this->lang->line('quantity'); ?></td>
                            <td width="15%"><?php echo $this->lang->line('amount'); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('opd'); ?></td>
                            <td><?php echo $opd_income->total_opd_quantity ?? 0; ?></td>
                            <td><?php echo $opd_income->total_opd_income ?? 0; ?></td>
                            <td><?php echo $this->lang->line('opd'); ?></td>
                            <td><?php echo $opd_expense->total_opd_quantity ?? 0; ?></td>
                            <td><?php echo $opd_expense->total_opd_expense ?? 0; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('ipd'); ?></td>
                            <td><?php echo $ipd_income->total_ipd_quantity ?? 0; ?></td>
                            <td><?php echo $ipd_income->total_ipd_income ?? 0; ?></td>
                            <td><?php echo $this->lang->line('ipd'); ?></td>
                            <td><?php echo $ipd_expense->total_ipd_quantity ?? 0; ?></td>
                            <td><?php echo $ipd_expense->total_ipd_expense ?? 0; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('diagnostic'); ?></td>
                            <td><?php echo $diagnostic_income->total_diagnostic_quantity ?? 0; ?></td>
                            <td><?php echo $diagnostic_income->total_diagnostic_income ?? 0; ?></td>
                            <td><?php echo $this->lang->line('diagnostic'); ?></td>
                            <td><?php echo $diagnostic_expense->total_diagnostic_quantity ?? 0; ?></td>
                            <td><?php echo $diagnostic_expense->total_diagnostic_expense ?? 0; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('pharmacy'); ?></td>
                            <td></td>
                            <td></td>
                            <td><?php echo $this->lang->line('surgeon'); ?></td>
                            <td><?php echo $surgeon_expense->total_surgeon_quantity ?? 0; ?></td>
                            <td><?php echo $surgeon_expense->total_surgeon_expense ?? 0; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('ambulance'); ?></td>
                            <td></td>
                            <td></td>
                            <td><?php echo $this->lang->line('anesthesia'); ?></td>
                            <td><?php echo $anesthesia_expense->total_anesthesia_quantity ?? 0; ?></td>
                            <td><?php echo $anesthesia_expense->total_anesthesia_expense ?? 0; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('blood_bank'); ?></td>
                            <td></td>
                            <td></td>
                            <td><?php echo $this->lang->line('assistant'); ?></td>
                            <td><?php echo $assistant_expense->total_assistant_quantity ?? 0; ?></td>
                            <td><?php echo $assistant_expense->total_assistant_expense ?? 0; ?></td>
                        </tr>
                    </tbody>
                </table>
                <?php if (isset($reference_id) && $reference_id == 0 && isset($type) && $type == 0) { ?>
                    <table class="table" style="border-collapse: collapse; margin-top: 20px;">
                        <tr>
                            <td valign="top">
                                <table class="table table_content">
                                    <thead>
                                        <tr>
                                            <th colspan="3"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('income'); ?></th>
                                        </tr>
                                        <tr>
                                            <th width="25%"><strong><?php echo $this->lang->line('income_head'); ?></strong></th>
                                            <th width="10%"><strong><?php echo $this->lang->line('quantity'); ?></strong></th>
                                            <th width="15%"><strong><?php echo $this->lang->line('amount'); ?></strong></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $income_opd_quantity = 0;
                                        $total_opd_income = 0;
                                        foreach ($incomes as $obj) {
                                            $ihe = $this->mis->get_income_head_opd_income($obj->income_head_id, $form_date, $to_date, $created_by);
                                            $income_opd_quantity += $ihe->total_income_quantity;
                                            $total_opd_income += $ihe->total_head_income;
                                        ?>
                                            <tr>
                                                <td><?php echo $obj->income_head; ?></td>
                                                <td><?php echo $ihe->total_income_quantity ?? 0; ?></td>
                                                <td><?php echo $ihe->total_head_income ?? 0; ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th align="right"><?php echo $this->lang->line('total'); ?></th>
                                            <th><?php echo $income_opd_quantity; ?></th>
                                            <th><?php echo $total_opd_income; ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </td>
                            <td valign="top">
                                <table class="table table_content">
                                    <thead>
                                        <tr>
                                            <th colspan="3"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('expense'); ?></th>
                                        </tr>
                                        <tr>
                                            <th width="50%"><strong><?php echo $this->lang->line('expenditure_head'); ?></strong></th>
                                            <th width="20%"><strong><?php echo $this->lang->line('quantity'); ?></strong></th>
                                            <th width="30%"><strong><?php echo $this->lang->line('amount'); ?></strong></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $expenditure_opd_quantity = 0;
                                        $total_opd_expenditure = 0;
                                        foreach ($expenditures as $obj) {
                                            $ehe = $this->mis->get_expenditure_head_opd_expense($obj->expenditure_head_id, $form_date, $to_date, $created_by);
                                            $expenditure_opd_quantity += $ehe->total_expenditure_quantity;
                                            $total_opd_expenditure += $ehe->total_expenditure_expense;
                                        ?>
                                            <tr>
                                                <td><?php echo $obj->expenditure_head; ?></td>
                                                <td><?php echo $ehe->total_expenditure_quantity ?? 0; ?></td>
                                                <td><?php echo $ehe->total_expenditure_expense ?? 0; ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th align="right"><?php echo $this->lang->line('total'); ?></th>
                                            <th><?php echo $expenditure_opd_quantity; ?></th>
                                            <th><?php echo $total_opd_expenditure; ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </td>
                        </tr>
                    </table>


                    <!-- IPD -->
                    <table class="table" style="border-collapse: collapse; margin-top: 20px;">
                        <tr>
                            <td valign="top">
                                <table class="table table_content">
                                    <thead>
                                        <tr>
                                            <th colspan="3"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('income'); ?></th>
                                        </tr>
                                        <tr>
                                            <th width="25%"><strong><?php echo $this->lang->line('income_head'); ?></strong></th>
                                            <th width="10%"><strong><?php echo $this->lang->line('quantity'); ?></strong></th>
                                            <th width="15%"><strong><?php echo $this->lang->line('amount'); ?></strong></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $income_ipd_quantity = 0;
                                        $total_ipd_income = 0;
                                        foreach ($incomes as $obj) {
                                            $ihe = $this->mis->get_income_head_ipd_income($obj->income_head_id, $form_date, $to_date, $created_by);
                                            $income_ipd_quantity += $ihe->total_income_quantity;
                                            $total_ipd_income += $ihe->total_head_income;
                                        ?>
                                            <tr>
                                                <td><?php echo $obj->income_head; ?></td>
                                                <td><?php echo $ihe->total_income_quantity ?? 0; ?></td>
                                                <td><?php echo $ihe->total_head_income ?? 0; ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th align="right"><?php echo $this->lang->line('total'); ?></th>
                                            <th><?php echo $income_ipd_quantity; ?></th>
                                            <th><?php echo $total_ipd_income; ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </td>
                            <td valign="top">
                                <table class="table table_content">
                                    <thead>
                                        <tr>
                                            <th colspan="3"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('expense'); ?></th>
                                        </tr>
                                        <tr>
                                            <th width="50%"><strong><?php echo $this->lang->line('expenditure_head'); ?></strong></th>
                                            <th width="20%"><strong><?php echo $this->lang->line('quantity'); ?></strong></th>
                                            <th width="30%"><strong><?php echo $this->lang->line('amount'); ?></strong></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $expenditure_ipd_quantity = 0;
                                        $total_ipd_expenditure = 0;
                                        foreach ($expenditures as $obj) {
                                            $ehe = $this->mis->get_expenditure_head_ipd_expense($obj->expenditure_head_id, $form_date, $to_date, $created_by);
                                            $expenditure_ipd_quantity += $ehe->total_expenditure_quantity;
                                            $total_ipd_expenditure += $ehe->total_expenditure_expense;
                                        ?>
                                            <tr>
                                                <td><?php echo $obj->expenditure_head; ?></td>
                                                <td><?php echo $ehe->total_expenditure_quantity ?? 0; ?></td>
                                                <td><?php echo $ehe->total_expenditure_expense ?? 0; ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th align="right"><?php echo $this->lang->line('total'); ?></th>
                                            <th><?php echo $expenditure_ipd_quantity; ?></th>
                                            <th><?php echo $total_ipd_expenditure; ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </td>
                        </tr>
                    </table>


                    <!-- OTHER -->
                    <table class="table" style="border-collapse: collapse; margin-top: 20px;">
                        <tr>
                            <td valign="top">
                                <table class="table table_content">
                                    <thead>
                                        <tr>
                                            <th colspan="3"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('income'); ?></th>
                                        </tr>
                                        <tr>
                                            <th width="25%"><strong><?php echo $this->lang->line('income_head'); ?></strong></th>
                                            <th width="10%"><strong><?php echo $this->lang->line('quantity'); ?></strong></th>
                                            <th width="15%"><strong><?php echo $this->lang->line('amount'); ?></strong></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $income_other_quantity = 0;
                                        $total_other_income = 0;
                                        foreach ($incomes as $obj) {
                                            $ihe = $this->mis->get_income_head_other_income($obj->income_head_id, $form_date, $to_date, $created_by);
                                            $income_other_quantity += $ihe->total_income_quantity;
                                            $total_other_income += $ihe->total_head_income;
                                        ?>
                                            <tr>
                                                <td><?php echo $obj->income_head; ?></td>
                                                <td><?php echo $ihe->total_income_quantity ?? 0; ?></td>
                                                <td><?php echo $ihe->total_head_income ?? 0; ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th align="right"><?php echo $this->lang->line('total'); ?></th>
                                            <th><?php echo $income_other_quantity; ?></th>
                                            <th><?php echo $total_other_income; ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </td>
                            <td valign="top">
                                <table class="table table_content">
                                    <thead>
                                        <tr>
                                            <th colspan="3"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('expense'); ?></th>
                                        </tr>
                                        <tr>
                                            <th width="50%"><strong><?php echo $this->lang->line('expenditure_head'); ?></strong></th>
                                            <th width="20%"><strong><?php echo $this->lang->line('quantity'); ?></strong></th>
                                            <th width="30%"><strong><?php echo $this->lang->line('amount'); ?></strong></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $expenditure_other_quantity = 0;
                                        $total_other_expenditure = 0;
                                        foreach ($expenditures as $obj) {
                                            $ehe = $this->mis->get_expenditure_head_other_expense($obj->expenditure_head_id, $form_date, $to_date, $created_by);
                                            $expenditure_other_quantity += $ehe->total_expenditure_quantity;
                                            $total_other_expenditure += $ehe->total_expenditure_expense;
                                        ?>
                                            <tr>
                                                <td><?php echo $obj->expenditure_head; ?></td>
                                                <td><?php echo $ehe->total_expenditure_quantity ?? 0; ?></td>
                                                <td><?php echo $ehe->total_expenditure_expense ?? 0; ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th align="right"><?php echo $this->lang->line('total'); ?></th>
                                            <th><?php echo $expenditure_other_quantity; ?></th>
                                            <th><?php echo $total_other_expenditure; ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </td>
                        </tr>
                    </table>
                <?php } else { ?>
                    <?php
                    $total_opd_income = 0;
                    $total_ipd_income = 0;
                    $total_other_income = 0;
                    $total_opd_expenditure = 0;
                    $total_ipd_expenditure = 0;
                    $total_other_expenditure = 0;
                    ?>
                <?php } ?>
                <?php echo $margin ?? ''; ?>

                <?php
                $total_income = $total_opd_income + $total_ipd_income + $total_other_income;
                $total_expenditure = $total_opd_expenditure + $total_ipd_expenditure + $total_other_expenditure;
                ?>
                <table class="table table_content" style="width: 60%; margin: 20px auto;">
                    <thead>
                        <tr>
                            <th class="text-right font-weight-600">Total Hospital Income</th>
                            <th class="text-left font-weight-600">
                                <?php $total_grand_income = ($opd_income->total_opd_income + $ipd_income->total_ipd_income + $diagnostic_income->total_diagnostic_income + $total_income); ?>
                                <?php echo number_format(($opd_income->total_opd_income + $ipd_income->total_ipd_income + $diagnostic_income->total_diagnostic_income + $total_income), 2); ?>
                            </th>
                        </tr>
                        <tr>
                            <th>Total Hospital Expense</th>
                            <th>
                                <?php $total_grand_expense = ($opd_expense->total_opd_expense + $ipd_expense->total_ipd_expense + $diagnostic_expense->total_diagnostic_expense + $surgeon_expense->total_surgeon_expense + $anesthesia_expense->total_anesthesia_expense + $assistant_expense->total_assistant_expense + $total_expenditure); ?>
                                <?php echo number_format(($opd_expense->total_opd_expense + $ipd_expense->total_ipd_expense + $diagnostic_expense->total_diagnostic_expense + $surgeon_expense->total_surgeon_expense + $anesthesia_expense->total_anesthesia_expense + $assistant_expense->total_assistant_expense + $total_expenditure), 2); ?>
                            </th>
                        </tr>
                        <tr>
                            <th>Total Hospital Balance</th>
                            <th>
                                <?php echo number_format(($total_grand_income - $total_grand_expense), 2); ?>
                            </th>
                        </tr>
                    </thead>
                </table>
            </div>
            <!-- Content End -->

            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Printed By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>