<!DOCTYPE html>
<html>

<head>
    <title>Investigation</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        tfoot th {
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">PATIENT COLLECTION REPORT</h2>
            <?php if ($form_date == $to_date) { ?>
                <p align="center">
                    <strong>Date:</strong> <?php echo date('M d, Y', strtotime($form_date)); ?>
                </p>
            <?php } else { ?>
                <p align="center">
                    <strong>Date:</strong> <?php echo date('M d, Y', strtotime($form_date)); ?> - <?php echo date('M d, Y', strtotime($to_date)); ?>
                <p>
                <?php } ?>
                <div class="info_table">
                    <table class="table">
                        <tbody>
                            <tr>
                                <td width="80%" align="left">
                                    <?php if (isset($reference_id) && !empty($reference_id)) { ?>
                                        <b>Reference:</b>
                                        <span style="font-size: 12px; margin: 0; padding: 0;">
                                            <?php echo $reference->name; ?>, <?php echo $reference->phone; ?>
                                        </span>
                                    <?php } else { ?>
                                        <b>Reference:</b>
                                        <span style="font-size: 12px; margin: 0; padding: 0;">
                                            All
                                        </span>
                                    <?php } ?>
                                </td>
                                <td width="20%" align="right">
                                    <b>Print Date:</b>
                                    <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <!-- Content Start-->
                <div class="content">
                    <table class="table table_content">
                        <thead>
                            <tr>
                                <th><?php echo $this->lang->line('date'); ?></th>
                                <th><?php echo $this->lang->line('patient_id'); ?></th>
                                <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                <th><?php echo $this->lang->line('test'); ?> <?php echo $this->lang->line('name'); ?></th>
                                <th><?php echo $this->lang->line('vd'); ?> <?php echo $this->lang->line('name'); ?></th>
                                <th><?php echo $this->lang->line('vd'); ?> <?php echo $this->lang->line('code'); ?></th>
                                <th width="9%"><?php echo $this->lang->line('total'); ?></th>
                                <th width="6%"><?php echo $this->lang->line('discount'); ?></th>
                                <th width="8%"><?php echo $this->lang->line('paid'); ?></th>
                                <th width="6%"><?php echo $this->lang->line('due'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $count = 1;
                            $total_count = 0;
                            $total_bill_amount = 0;
                            $total_discount = 0;
                            $total_advanced = 0;
                            $total_due_amount = 0;
                            if (isset($investigations) && !empty($investigations)) { ?>
                                <?php foreach ($investigations as $obj) {
                                    $test = $this->marketing->get_patient_test_list($obj->id, $obj->patient_id);
                                    $total_count += $count;
                                    $total_bill_amount += $obj->total_bill;
                                    $total_discount += $obj->discount;
                                    $total_advanced += $obj->advanced;
                                    $total_due_amount += $obj->due_amount;
                                ?>
                                    <tr>
                                        <td><?php echo date('Y-m-d h:ia',strtotime($obj->bill_date)); ?></td>
                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                        <td><?php echo $obj->patient; ?></td>
                                        <td>
                                            <?php
                                            $str = "";
                                            foreach ($test as $item) {
                                                $str .= $item->test_name . ', ';
                                            }
                                            echo rtrim($str, ', ');
                                            ?>
                                        </td>
                                        <td><?php echo $obj->reference; ?></td>
                                        <td><?php echo $obj->marketing_name; ?></td>
                                        <td><?php echo $obj->total_bill; ?></td>
                                        <td><?php echo $obj->discount; ?></td>
                                        <td><?php echo $obj->advanced; ?></td>
                                        <td><?php echo $obj->due_amount; ?></td>
                                    </tr>
                                <?php } ?>
                            <?php } ?>
                        </tbody>
                        <tfoot class="border-bottom border-1">
                            <tr>
                                <th colspan="5" align="right" class="text-right font-weight-600">Total</th>
                                <th class="text-right font-weight-600"><?php echo $total_count; ?></th>
                                <th class="text-right font-weight-600"><?php echo number_format($total_bill_amount, 2); ?></th>
                                <th class="text-right font-weight-600"><?php echo number_format($total_discount, 2); ?></th>
                                <th class="text-right font-weight-600"><?php echo number_format($total_advanced, 2); ?><P></P>
                                </th>
                                <th class="text-right font-weight-600"><?php echo number_format($total_due_amount, 2); ?></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                <!-- Content End -->
        </div>
    </div>
</body>

</html>