<!DOCTYPE html>
<html>

<head>
    <title>Rejected</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">REJECTED BILL REPORT</h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <?php if (isset($doctor_id) && !empty($doctor_id)) { ?>
                                    <b>Doctor:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $doctor->name; ?>, <?php echo $doctor->specialist; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Doctor:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="20%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th style="width: 5%;">SL No</th>
                            <th style="width: 9%;">Invoice No</th>
                            <th style="width: 12%;">Date</th>
                            <th style="width: 8%;">Patient ID</th>
                            <th style="width: 10%;">Patient Name</th>
                            <th style="width: 10%;">Doctor</th>
                            <th style="width: 10%;">Reference</th>
                            <th style="width: 6%;">Total</th>
                            <th style="width: 6%;">Advanced</th>
                            <th style="width: 14%;">Reason</th>
                            <th style="width: 10%;">Created By</th>
                            <th style="width: 10%;">Rejected By</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        $total_bill_amount = 0;
                        $total_special_discount = 0;
                        $total_discount = 0;
                        $total_net_payable = 0;
                        $total_advanced = 0;
                        $total_due_amount = 0;
                        $total_commission_amount = 0;
                        $total_payable_commission = 0;
                        $total_hospital_income = 0;
                        if (isset($rejecteds) && !empty($rejecteds)) { ?>
                            <?php foreach ($rejecteds as $obj) {
                                $total_bill_amount += $obj->total_bill;
                                if ($obj->commission_user_id > 0) {
                                    $total_payable_commission += ($obj->payable_commission - $obj->discount);
                                    $total_commission_amount += $obj->commission_amount;
                                    $total_hospital_income += ($obj->total_bill - $obj->payable_commission);
                                } else {
                                    $total_hospital_income += ($obj->total_bill - $obj->discount);
                                }
                                $total_discount += $obj->discount;
                                $total_net_payable += $obj->net_payable;
                                $total_advanced += $obj->advanced;
                                $total_due_amount += $obj->due_amount;
                            ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo date('d/m/Y h:i A', strtotime($obj->bill_date)); ?></td>
                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                    <td><?php echo $obj->patient; ?></td>
                                    <td><?php echo $obj->doctor; ?></td>
                                    <td><?php echo $obj->reference; ?></td>
                                    <td><?php echo $obj->total_bill; ?></td>
                                    <td><?php echo $obj->advanced; ?></td>
                                    <td><?php echo $obj->note; ?></td>
                                    <td><?php echo $obj->created_by; ?></td>
                                    <td><?php echo $obj->rejected_by; ?></td>
                                </tr>
                            <?php } ?>
                            <tr>
                                <td colspan="10" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Amount:</th>
                                <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_bill_amount, 2); ?></th>
                            </tr>
                            <tr>
                                <td colspan="10" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Special Discount:</th>
                                <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_special_discount, 2); ?></th>
                            </tr>
                            <tr>
                                <td colspan="10" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Discount:</th>
                                <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_discount, 2); ?></th>
                            </tr>
                            <tr>
                                <td colspan="10" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Net Payable:</th>
                                <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_net_payable, 2); ?></th>
                            </tr>
                            <tr>
                                <td colspan="10" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Advanced:</th>
                                <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_advanced, 2); ?></th>
                            </tr>
                            <tr>
                                <td colspan="10" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Due Amount:</th>
                                <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_due_amount, 2); ?></th>
                            </tr>
                            <tr>
                                <td colspan="10" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Commission:</td>
                                <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_commission_amount, 2); ?></td>
                            </tr>
                            <tr>
                                <td colspan="10" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Payable Commission:</th>
                                <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_payable_commission, 2); ?></th>
                            </tr>
                            <tr>
                                <td colspan="10" align="right" style="padding-right: 5px;">Hospital Income:</th>
                                <td colspan="2" align="left" style="padding-left: 5px;"><?php echo number_format($total_hospital_income, 2); ?></th>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php if (isset($created_by) && !empty($created_by)) {
                                        echo $createdby->name;
                                    } else {
                                        echo $this->session->userdata('name');
                                    } ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>