<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('yearly'); ?> <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php echo $this->load->view('header'); ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/attendance/yearly'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="year"><?php echo $this->lang->line('year'); ?></label>
                            <input type="text" minlength="4" maxlength="4" class="form-control" name="year" id="year" value="<?php echo isset($year) ?  $year : ''; ?>" placeholder="<?php echo $this->lang->line('year'); ?>" autocomplete="off" required>
                        </div>
                        <div class="col-md-7 mb-10">
                            <label for="user_id"><?php echo $this->lang->line('employee'); ?></label>
                            <select class="form-control custom-select select2" name="user_id" id="user_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($user_id) && $user_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if (isset($year) && !empty($year)) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-clock-o font-30 mr-10"></i>
                                <?php echo $this->lang->line('yearly'); ?> <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <?php if (has_permission(ADD, 'report', 'attendance')) { ?>
                            <div class="button-list">
                                <a href="<?php echo site_url('report/attendance/yearly_pdf?year=' . $year . '&user_id=' . $user_id); ?>" class="btn btn-success btn-xs">
                                    <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="card-body">
                        <blockquote class="blockquote text-center w-50 m-auto">
                           <h2><?php echo $this->lang->line('yearly'); ?> <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('report'); ?></h2>
                           <p><?php echo $this->lang->line('employee'); ?>: <?php echo $employee->name; ?></p>
                           <p><?php echo $this->lang->line('year'); ?>: <?php echo $year; ?></p>
                        </blockquote>
                        <style>
                            .table-sm td,
                            .table-sm th {
                                padding: 0 !important;
                            }
                        </style>
                        <div class="table-wrap mt-3">
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered table-hover table-striped mb-0">
                                    <thead class="bg-gradient-streaks text-white">
                                        <tr>
                                            <th class="text-white">
                                                Month <i class="fa fa-long-arrow-down"></i>
                                                Date <i class="fa fa-long-arrow-right"></i>
                                            </th>
                                            <?php for ($i = 1; $i <= $days; $i++) {
                                                $i = str_pad($i, 2, 0, STR_PAD_LEFT);
                                            ?>
                                                <th class="text-white text-center">
                                                    <strong><?php echo $i; ?></strong>
                                                </th>
                                            <?php } ?>
                                            <th class="text-white text-center">
                                                <strong>Total</strong>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $months = get_months();
                                        foreach ($months as $key => $value) {
                                            $month = date('m', strtotime($key));
                                        ?>
                                            <tr>
                                                <td><?php echo $value; ?></td>
                                                <?php for ($i = 1; $i <= $days; $i++) {
                                                    $i = str_pad($i, 2, 0, STR_PAD_LEFT);
                                                    $attendance_date = $year . '-' . $month . '-' . $i;
                                                    // Attendance fetch
                                                    $attendance = $this->attendance->get_monthly_attendance_list($attendance_date, null, $user_id);
                                                ?>
                                                    <?php if (isset($attendance) && !empty($attendance)) { ?>
                                                        <?php foreach ($attendance as $row) { ?>
                                                            <td class="text-uppercase text-center"><?php echo $row->attendance_status; ?></td>
                                                        <?php } ?>
                                                    <?php } else { ?>
                                                        <td class="text-uppercase text-center">--</td>
                                                    <?php } ?>
                                                <?php } ?>
                                                <td class="text-center">
                                                    <?php
                                                    $total_present = $this->attendance->get_total_present_count($user_id, $year, $month);
                                                    echo $total_present ? $total_present : '';
                                                    ?>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
</script>