<!DOCTYPE html>
<html>

<head>
    <title>Summary</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .table_content tfoot th {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }

        .text-right {
            text-align: right;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">
                SUMMARY ATTENDANCE REPORT<br>
                <small>Date: <?php echo date('M d, Y', strtotime($date)); ?></small>
            </h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%" align="left">
                                <b>Department:</b>
                                <span style="font-size: 12px; margin: 0; padding: 0;">
                                    All
                                </span>
                            </td>
                            <td width="30%" align="right">
                                <b>Print Date:</b>
                                <span style="font-size: 12px;"><?php echo date('M d, Y h:ia'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th class="text-white"><?php echo $this->lang->line('sl_no'); ?></th>
                            <th class="text-white"><?php echo $this->lang->line('department'); ?></th>
                            <th class="text-white"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('employee'); ?></th>
                            <th class="text-white"><?php echo $this->lang->line('male'); ?></th>
                            <th class="text-white"><?php echo $this->lang->line('female'); ?></th>
                            <th class="text-white"><?php echo $this->lang->line('present'); ?></th>
                            <th class="text-white"><?php echo $this->lang->line('absent'); ?></th>
                            <th class="text-white"><?php echo $this->lang->line('leave'); ?></th>
                            <th class="text-white"><?php echo $this->lang->line('weekend'); ?></th>
                            <th class="text-white"><?php echo $this->lang->line('late'); ?></th>
                            <th class="text-white"><?php echo $this->lang->line('early_leaving'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        $total_employee = 0;
                        $total_male = 0;
                        $total_female = 0;
                        $total_present = 0;
                        $total_absent = 0;
                        $total_leave = 0;
                        $total_weekend = 0;
                        $total_late = 0;
                        $total_early_leaving = 0;
                        if (isset($attendances) && !empty($attendances)) { ?>
                            <?php foreach ($attendances as $obj) { ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?php echo $obj->name; ?></td>
                                    <td>
                                        <?php
                                        $employee = $this->attendance->count_all('employees', array('employee_type' => 'staff', 'department_id' => $obj->id, 'status' => 1));
                                        echo $employee;
                                        $total_employee += $employee;
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        $male = $this->attendance->count_all('employees', array('gender' => 'male', 'employee_type' => 'staff', 'department_id' => $obj->id, 'status' => 1));
                                        echo $male;
                                        $total_male += $male;
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        $female = $this->attendance->count_all('employees', array('gender' => 'female', 'employee_type' => 'staff', 'department_id' => $obj->id, 'status' => 1));
                                        echo $female;
                                        $total_female += $female;
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        $present = $this->attendance->get_summary_count_attendance($obj->id, $date, 'p', null);
                                        echo $present;
                                        $total_present += $present;
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        $absent = $this->attendance->get_summary_count_attendance($obj->id, $date, 'a', null);
                                        echo $absent;
                                        $total_absent += $absent;
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        $leave = $this->attendance->get_summary_count_attendance($obj->id, $date, 'l', null);
                                        echo $leave;
                                        $total_leave += $leave;
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        $weekend = $this->attendance->get_summary_count_attendance($obj->id, $date, 'w', null);
                                        echo $weekend;
                                        $total_weekend += $weekend;
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        $late = $this->attendance->get_summary_count_attendance($obj->id, $date, null, 'late');
                                        echo $late;
                                        $total_late += $late;
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        $early_leaving = $this->attendance->get_summary_count_attendance($obj->id, $date, null, 'early_leaving');
                                        echo $early_leaving;
                                        $total_early_leaving += $early_leaving;
                                        ?>
                                    </td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                    <tfoot class="bg-gradient-primary">
                        <tr>
                            <th colspan="2" class="text-right font-weight-600 text-white"><?php echo $this->lang->line('total'); ?></th>
                            <th class="font-weight-600 text-white"><?php echo $total_employee; ?></th>
                            <th class="font-weight-600 text-white"><?php echo $total_male; ?></th>
                            <th class="font-weight-600 text-white"><?php echo $total_female; ?></th>
                            <th class="font-weight-600 text-white"><?php echo $total_present; ?></th>
                            <th class="font-weight-600 text-white"><?php echo $total_absent; ?></th>
                            <th class="font-weight-600 text-white"><?php echo $total_leave; ?></th>
                            <th class="font-weight-600 text-white"><?php echo $total_weekend; ?></th>
                            <th class="font-weight-600 text-white"><?php echo $total_late; ?></th>
                            <th class="font-weight-600 text-white"><?php echo $total_early_leaving; ?></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>