<!DOCTYPE html>
<html>

<head>
    <title>Leave</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">
                LEAVE REPORT<br>
                <small>Date: <?php echo date('M d, Y', strtotime($form_date)); ?> - <?php echo date('M d, Y', strtotime($to_date)); ?></small>
            </h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%" align="left">
                                <?php if (isset($user_id) && !empty($user_id)) { ?>
                                    <b>Employee:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $employee->name; ?>, <?php echo $employee->phone; ?>
                                    </span>
                                <?php } elseif (isset($department_id) && !empty($department_id)) { ?>
                                    <b>Department:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $department->name; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Employee:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="30%" align="right">
                                <b>Print Date:</b>
                                <span style="font-size: 12px;"><?php echo date('M d, Y h:ia'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                            <th><?php echo $this->lang->line('name'); ?></th>
                            <th><?php echo $this->lang->line('designation'); ?></th>
                            <th><?php echo $this->lang->line('type'); ?></th>
                            <th><?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('from'); ?></th>
                            <th><?php echo $this->lang->line('leave'); ?> <?php echo $this->lang->line('to'); ?></th>
                            <th><?php echo $this->lang->line('total'); ?></th>
                            <th><?php echo $this->lang->line('applied'); ?></th>
                            <th><?php echo $this->lang->line('approved'); ?> <?php echo $this->lang->line('date'); ?></th>
                            <th><?php echo $this->lang->line('approved'); ?></th>
                            <th><?php echo $this->lang->line('status'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        if (isset($leaves) && !empty($leaves)) { ?>
                            <?php foreach ($leaves as $obj) { ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?php echo $obj->name; ?></td>
                                    <td><?php echo $obj->designation; ?></td>
                                    <td><?php echo $obj->type; ?></td>
                                    <td><?php echo $obj->leave_from ? date('M d, Y', strtotime($obj->leave_from)) : ''; ?></td>
                                    <td><?php echo $obj->leave_to ? date('M d, Y', strtotime($obj->leave_to)) : ''; ?></td>
                                    <td><?php echo $obj->total_leave_day; ?> <?php echo $this->lang->line('day'); ?></td>
                                    <td><?php echo $obj->created_at ? date('M d, Y', strtotime($obj->created_at)) : ''; ?></td>
                                    <td><?php echo $obj->modified_at ? date('M d, Y', strtotime($obj->modified_at)) : ''; ?></td>
                                    <td><?php echo $obj->modified_by ? $obj->modified_by : ''; ?></td>
                                    <td>
                                        <?php if ($obj->leave_status == 'waiting') {
                                            echo '<span class="badge badge-info">' . $this->lang->line('waiting') . '</span>';
                                        } elseif ($obj->leave_status == 'approved') {
                                            echo '<span class="badge badge-success">' . $this->lang->line('approved') . '</span>';
                                        } else {
                                            echo '<span class="badge badge-danger">' . $this->lang->line('declined') . '</span>';
                                        } ?>
                                    </td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>