<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('late'); ?> <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php echo $this->load->view('header'); ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/attendance/late'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="user_id"><?php echo $this->lang->line('employee'); ?></label>
                            <select class="form-control custom-select select2" name="user_id" id="user_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($user_id) && $user_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?></label>
                            <select class="form-control custom-select select2" name="department_id" id="department_id" onchange="get_designation(this.value)">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('department'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="designation_id"><?php echo $this->lang->line('designation'); ?></label>
                            <select class="form-control custom-select select2" name="designation_id" id="designation_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('designation'); ?></option>
                                <?php foreach ($designations as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($designation_id) && $designation_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="shift_id"><?php echo $this->lang->line('shift'); ?></label>
                            <select class="form-control custom-select select2" name="shift_id" id="shift_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('shift'); ?></option>
                                <?php foreach ($shifts as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($shift_id) && $shift_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($createds as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if (isset($attendances) && !empty($attendances)) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'attendance')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-clock-o font-30 mr-10"></i>
                                <?php echo $this->lang->line('late'); ?> <?php echo $this->lang->line('attendance'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <?php if (has_permission(ADD, 'report', 'attendance')) { ?>
                            <div class="button-list">
                                <a href="<?php echo site_url('report/attendance/late_pdf?date=' . $date . '&user_id=' . $user_id . '&department_id=' . $department_id . '&designation_id=' . $designation_id . '&shift_id=' . $shift_id . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs">
                                    <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('designation'); ?></th>
                                            <th><?php echo $this->lang->line('shift'); ?></th>
                                            <th><?php echo $this->lang->line('date'); ?></th>
                                            <th><?php echo $this->lang->line('in_time'); ?></th>
                                            <th><?php echo $this->lang->line('clock_in'); ?></th>
                                            <th><?php echo $this->lang->line('late'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        if (isset($attendances) && !empty($attendances)) { ?>
                                            <?php foreach ($attendances as $obj) { ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td><?php echo $obj->name; ?></td>
                                                    <td><?php echo $obj->designation; ?></td>
                                                    <td><?php echo $obj->shift; ?></td>
                                                    <td><?php echo date('M d, Y', strtotime($obj->date)); ?></td>
                                                    <td><?php echo $obj->in_time ? date('h:ia', strtotime($obj->in_time)) : ''; ?></td>
                                                    <td><?php echo $obj->clock_in ? date('h:ia', strtotime($obj->clock_in)) : ''; ?></td>
                                                    <td>
                                                        <?php
                                                        if ($obj->late) {
                                                            echo date('H', strtotime($obj->late)) > 0 ? date('H', strtotime($obj->late)) . 'H ' : '';
                                                            echo date('i', strtotime($obj->late)) > 0 ?  date('i', strtotime($obj->late)) . 'M' : '';
                                                        } ?>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>


<script>
    function get_designation(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_designation'); ?>",
            data: {
                department_id: department_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#designation_id').html(response);
                }
            }
        });
    };
</script>