<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Schedule_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_doctor_list() {
        $this->db->select('C.*, E.name, E.phone, E.user_id');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }
    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST, MARKETING));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST, MARKETING));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_schedule_list($slot, $form_date, $to_date, $status, $doctor_id, $created_by) {
        $this->db->select('S.*, D.name as doctor, D.bn_name as doctor_bn, C.name as created_by');
        $this->db->from('doctor_schedules AS S');
        $this->db->join('employees AS D', 'D.user_id = S.doctor_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = S.created_by', 'left');
        if ($slot) {
            $this->db->where('S.slot', $slot);
            if ($status == 1) {
                $this->db->where('S.status', 0);
            } else {
                $this->db->where('S.status', 1);
            }
        } else {
            if ($doctor_id == '') {
                $this->db->group_by('S.doctor_id');
            }
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(S.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('S.doctor_id', $doctor_id);
            $this->db->group_by('S.date');
        }
        if ($created_by) {
            $this->db->where('S.created_by', $created_by);
        }
        $this->db->order_by('D.sort_by', 'ASC');
        return $this->db->get()->result();
    }
}
