<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Attendance.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Attendance
 * @description     : Manage attendance report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Attendance extends MY_Controller
{

    public $data = array();

    function __construct()
    {
        parent::__construct();
        $this->load->model('Attendance_Model', 'attendance', true);

        $this->data['shifts'] = $this->attendance->get_list('shifts', array('status' => 1));
        $this->data['employees'] = $this->attendance->get_employee_list();
        $this->data['createds'] = $this->attendance->get_created_by_list();
        $this->data['departments'] = $this->attendance->get_list('departments', array('status' => 1));
        $this->data['designations'] = $this->attendance->get_list('designations', array('status' => 1));
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index()
    {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('attendance') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/attendance/index', $this->data);
    }

    /*****************Function daily**********************************
     * @type            : Function
     * @function name   : daily
     * @description     : Load "Daily Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function daily()
    {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $type = $this->input->get('type');
            $attendance_status = trim($this->input->get('attendance_status'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $user_id = $this->input->get('user_id');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $shift_id = $this->input->get('shift_id');
            $created_by = $this->input->get('created_by');

            $this->data['attendances'] = $this->attendance->get_daily_attendance_list($type, $attendance_status, $form_date, $to_date, $user_id, $department_id, $designation_id, $shift_id, $created_by);
            $this->data['type'] = $type;
            $this->data['attendance_status'] = $attendance_status;
            $this->data['date'] = $date;
            $this->data['user_id'] = $user_id;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['shift_id'] = $shift_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('daily') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/attendance/daily', $this->data);
    }

    /*****************Function daily_pdf**********************************
     * @type            : Function
     * @function name   : daily_pdf
     * @description     : Load "Generate Daily Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function daily_pdf()
    {

        check_permission(ADD);

        if ($_GET && $this->input->get('date')) {
            $type = $this->input->get('type');
            $attendance_status = trim($this->input->get('attendance_status'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $user_id = $this->input->get('user_id');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $shift_id = $this->input->get('shift_id');
            $created_by = $this->input->get('created_by');

            $this->data['attendances'] = $this->attendance->get_daily_attendance_list($type, $attendance_status, $form_date, $to_date, $user_id, $department_id, $designation_id, $shift_id, $created_by);
            $this->data['type'] = $type;
            $this->data['attendance_status'] = $attendance_status;
            $this->data['date'] = $date;
            $this->data['user_id'] = $user_id;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['shift_id'] = $shift_id;
            $this->data['created_by'] = $created_by;

            $this->data['employee'] = $this->attendance->get_single('employees', array('user_id' => $user_id, 'status' => 1));
            $this->data['department'] = $this->attendance->get_single('departments', array('id' => $department_id, 'status' => 1));
            $this->data['shift'] = $this->attendance->get_single('shifts', array('id' => $shift_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/attendance/pdf/daily', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('daily_' . rand() . '.pdf', 'I');
        }
    }

    /*****************Function not_in_office**********************************
     * @type            : Function
     * @function name   : not_in_office
     * @description     : Load "Daily Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function not_in_office()
    {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $date =  date('Y-m-d', strtotime($this->input->get('date')));
            $user_id = $this->input->get('user_id');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $shift_id = $this->input->get('shift_id');
            $created_by = $this->input->get('created_by');

            $this->data['attendances'] = $this->attendance->get_not_in_office_attendance_list($user_id, $department_id, $designation_id, $shift_id, $created_by);
            $this->data['date'] = $date;
            $this->data['user_id'] = $user_id;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['shift_id'] = $shift_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('daily') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/attendance/not-in-office', $this->data);
    }

     /*****************Function not_in_office_pdf**********************************
     * @type            : Function
     * @function name   : daily_pdf
     * @description     : Load "Generate Daily Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function not_in_office_pdf()
    {

        check_permission(ADD);

        if ($_GET && $this->input->get('date')) {
            $date =  date('Y-m-d', strtotime($this->input->get('date')));
            $user_id = $this->input->get('user_id');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $shift_id = $this->input->get('shift_id');
            $created_by = $this->input->get('created_by');

            $this->data['attendances'] = $this->attendance->get_not_in_office_attendance_list($user_id, $department_id, $designation_id, $shift_id, $created_by);
            $this->data['date'] = $date;
            $this->data['user_id'] = $user_id;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['shift_id'] = $shift_id;
            $this->data['created_by'] = $created_by;

            $this->data['employee'] = $this->attendance->get_single('employees', array('user_id' => $user_id, 'status' => 1));
            $this->data['department'] = $this->attendance->get_single('departments', array('id' => $department_id, 'status' => 1));
            $this->data['shift'] = $this->attendance->get_single('shifts', array('id' => $shift_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'P'
            ]);
            $html =  $this->load->view('report/attendance/pdf/not-in-office', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('daily_' . rand() . '.pdf', 'I');
        }
    }

    /*****************Function monthly**********************************
     * @type            : Function
     * @function name   : monthly
     * @description     : Load "Monthly Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function monthly()
    {

        check_permission(VIEW);

        if ($_GET && $this->input->get('month')) {
            $month = $this->input->get('month');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $shift_id = $this->input->get('shift_id');
            $user_id = $this->input->get('user_id');

            $this->data['attendances'] = $this->attendance->get_attendance_employee_list($department_id, $designation_id, $shift_id, $user_id);
            $this->data['month'] = $month;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['shift_id'] = $shift_id;
            $this->data['user_id'] = $user_id;

            $month_number = $month ? date('m', strtotime($month)) : NULL;
            $year_number  = $month ? date('Y', strtotime($month)) : NULL;
            $this->data['days']  = date('t', mktime(0, 0, 0, $month_number, 1, $year_number));
            $this->data['year_number'] = $year_number;
            $this->data['month_number'] = $month_number;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('monthly') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/attendance/monthly', $this->data);
    }

    /*****************Function monthly_pdf**********************************
     * @type            : Function
     * @function name   : monthly_pdf
     * @description     : Load "Generate Monthly Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function monthly_pdf()
    {

        check_permission(ADD);

        if ($_GET && $this->input->get('month')) {
            $month = $this->input->get('month');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $shift_id = $this->input->get('shift_id');
            $user_id = $this->input->get('user_id');

            $this->data['employees'] = $this->attendance->get_attendance_employee_list($department_id, $designation_id, $shift_id, $user_id);
            $this->data['month'] = $month;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['shift_id'] = $shift_id;
            $this->data['user_id'] = $user_id;

            $month_number = $month ? date('m', strtotime($month)) : NULL;
            $year_number  = $month ? date('Y', strtotime($month)) : NULL;
            $this->data['days']  = date('t', mktime(0, 0, 0, $month_number, 1, $year_number));
            $this->data['year_number'] = $year_number;
            $this->data['month_number'] = $month_number;

            $this->data['employee'] = $this->attendance->get_single('employees', array('user_id' => $user_id, 'status' => 1));
            $this->data['department'] = $this->attendance->get_single('departments', array('id' => $department_id, 'status' => 1));
            $this->data['shift'] = $this->attendance->get_single('shifts', array('id' => $shift_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L',
                'format' => 'Legal'
            ]);
            $html =  $this->load->view('report/attendance/pdf/monthly', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('monthly_' . rand() . '.pdf', 'I');
        }
    }

    /*****************Function yearly**********************************
     * @type            : Function
     * @function name   : yearly
     * @description     : Load "Yearly Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function yearly()
    {

        check_permission(VIEW);

        if ($_GET && $this->input->get('year')) {
            $year = $this->input->get('year');
            $user_id = $this->input->get('user_id');
            $this->data['year'] = $year;
            $this->data['user_id'] = $user_id;
            $this->data['days']  = 31;
            $this->data['employee']  = $this->attendance->get_single('employees', array('user_id' => $user_id, 'status' => 1));
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('yearly') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/attendance/yearly', $this->data);
    }

    /*****************Function yearly_pdf**********************************
     * @type            : Function
     * @function name   : yearly_pdf
     * @description     : Load "Generate Yearly Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function yearly_pdf()
    {

        check_permission(ADD);

        if ($_GET && $this->input->get('year')) {
            $year = $this->input->get('year');
            $user_id = $this->input->get('user_id');
            $this->data['year'] = $year;
            $this->data['user_id'] = $user_id;
            $this->data['days']  = 31;
            $this->data['employee']  = $this->attendance->get_single('employees', array('user_id' => $user_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/attendance/pdf/yearly', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('yearly_' . rand() . '.pdf', 'I');
        }
    }

    /*****************Function late**********************************
     * @type            : Function
     * @function name   : late
     * @description     : Load "Late Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function late()
    {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $user_id = $this->input->get('user_id');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $shift_id = $this->input->get('shift_id');
            $created_by = $this->input->get('created_by');

            $this->data['attendances'] = $this->attendance->get_late_attendance_list($form_date, $to_date, $user_id, $department_id, $designation_id, $shift_id, $created_by);
            $this->data['date'] = $date;
            $this->data['user_id'] = $user_id;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['shift_id'] = $shift_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('late') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/attendance/late', $this->data);
    }

    /*****************Function late_pdf**********************************
     * @type            : Function
     * @function name   : late_pdf
     * @description     : Load "Generate Late Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function late_pdf()
    {

        check_permission(ADD);

        if ($_GET && $this->input->get('date')) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $user_id = $this->input->get('user_id');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $shift_id = $this->input->get('shift_id');
            $created_by = $this->input->get('created_by');

            $this->data['attendances'] = $this->attendance->get_late_attendance_list($form_date, $to_date, $user_id, $department_id, $designation_id, $shift_id, $created_by);
            $this->data['date'] = $date;
            $this->data['user_id'] = $user_id;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['shift_id'] = $shift_id;
            $this->data['created_by'] = $created_by;

            $this->data['employee'] = $this->attendance->get_single('employees', array('user_id' => $user_id, 'status' => 1));
            $this->data['department'] = $this->attendance->get_single('departments', array('id' => $department_id, 'status' => 1));
            $this->data['shift'] = $this->attendance->get_single('shifts', array('id' => $shift_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/attendance/pdf/late', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('late_' . rand() . '.pdf', 'I');
        }
    }

    /*****************Function early_leaving**********************************
     * @type            : Function
     * @function name   : early_leaving
     * @description     : Load "Early Leaving Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function early_leaving()
    {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $user_id = $this->input->get('user_id');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $shift_id = $this->input->get('shift_id');
            $created_by = $this->input->get('created_by');

            $this->data['attendances'] = $this->attendance->get_early_leaving_attendance_list($form_date, $to_date, $user_id, $department_id, $designation_id, $shift_id, $created_by);
            $this->data['date'] = $date;
            $this->data['user_id'] = $user_id;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['shift_id'] = $shift_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('early_leaving') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/attendance/early_leaving', $this->data);
    }

    /*****************Function early_leaving_pdf**********************************
     * @type            : Function
     * @function name   : early_leaving_pdf
     * @description     : Load "Generate Early Leaving Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function early_leaving_pdf()
    {

        check_permission(ADD);

        if ($_GET && $this->input->get('date')) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $user_id = $this->input->get('user_id');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $shift_id = $this->input->get('shift_id');
            $created_by = $this->input->get('created_by');

            $this->data['attendances'] = $this->attendance->get_early_leaving_attendance_list($form_date, $to_date, $user_id, $department_id, $designation_id, $shift_id, $created_by);
            $this->data['date'] = $date;
            $this->data['user_id'] = $user_id;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['shift_id'] = $shift_id;
            $this->data['created_by'] = $created_by;

            $this->data['employee'] = $this->attendance->get_single('employees', array('user_id' => $user_id, 'status' => 1));
            $this->data['department'] = $this->attendance->get_single('departments', array('id' => $department_id, 'status' => 1));
            $this->data['shift'] = $this->attendance->get_single('shifts', array('id' => $shift_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/attendance/pdf/early_leaving', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('early_leaving_' . rand() . '.pdf', 'I');
        }
    }

    /*****************Function summary**********************************
     * @type            : Function
     * @function name   : summary
     * @description     : Load "Summary Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function summary()
    {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $date = $this->input->get('date');
            $department_id = $this->input->get('department_id');
            $this->data['date'] = $date;
            $this->data['department_id'] = $department_id;
            $this->data['attendances'] = $this->attendance->get_summary_attendance_list($department_id);
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('summary') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/attendance/summary', $this->data);
    }

    /*****************Function summary_pdf**********************************
     * @type            : Function
     * @function name   : summary_pdf
     * @description     : Load "Generate Summary Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function summary_pdf()
    {

        check_permission(ADD);

        if ($_GET && $this->input->get('date')) {
            $date = $this->input->get('date');
            $department_id = $this->input->get('department_id');
            $this->data['date'] = $date;
            $this->data['department_id'] = $department_id;
            $this->data['attendances'] = $this->attendance->get_summary_attendance_list($department_id);
            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/attendance/pdf/summary', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('summary_' . rand() . '.pdf', 'I');
        }
    }


    /*****************Function leave**********************************
     * @type            : Function
     * @function name   : leave
     * @description     : Load "Leave Attendance Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function leave()
    {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $leave_status = $this->input->get('leave_status');
            $leave_type_id = trim($this->input->get('leave_type_id'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $user_id = $this->input->get('user_id');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $modified_by = $this->input->get('modified_by');

            $this->data['leaves'] = $this->attendance->get_leave_list($leave_status, $leave_type_id, $form_date, $to_date, $user_id, $department_id, $designation_id, $modified_by);
            $this->data['leave_status'] = $leave_status;
            $this->data['leave_type_id'] = $leave_type_id;
            $this->data['date'] = $date;
            $this->data['user_id'] = $user_id;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['modified_by'] = $modified_by;
        }

        $this->data['types'] = $this->attendance->get_list('leave_types', array('status' => 1));
        $this->data['approved'] = $this->attendance->get_created_by_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('leave') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/attendance/leave', $this->data);
    }

    /*****************Function leave_pdf**********************************
     * @type            : Function
     * @function name   : leave_pdf
     * @description     : Load "Generate Leave Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function leave_pdf()
    {

        check_permission(ADD);

        if ($_GET && $this->input->get('date')) {
            $leave_status = $this->input->get('leave_status');
            $leave_type_id = trim($this->input->get('leave_type_id'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $user_id = $this->input->get('user_id');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $modified_by = $this->input->get('modified_by');

            $this->data['leaves'] = $this->attendance->get_leave_list($leave_status, $leave_type_id, $form_date, $to_date, $user_id, $department_id, $designation_id, $modified_by);
            $this->data['leave_status'] = $leave_status;
            $this->data['leave_type_id'] = $leave_type_id;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['user_id'] = $user_id;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['modified_by'] = $modified_by;

            $this->data['employee'] = $this->attendance->get_single('employees', array('user_id' => $user_id, 'status' => 1));
            $this->data['department'] = $this->attendance->get_single('departments', array('id' => $department_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/attendance/pdf/leave', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('leave_' . rand() . '.pdf', 'I');
        }
    }


    /*****************Function holiday**********************************
     * @type            : Function
     * @function name   : holiday
     * @description     : Load "Holiday Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function holiday()
    {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $created_by = $this->input->get('created_by');

            $this->data['holidays'] = $this->attendance->get_holiday_list($form_date, $to_date, $created_by);
            $this->data['date'] = $date;
            $this->data['created_by'] = $created_by;
        }

        $this->data['created'] = $this->attendance->get_created_by_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('holiday') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/attendance/holiday', $this->data);
    }

    /*****************Function holiday_pdf**********************************
     * @type            : Function
     * @function name   : holiday_pdf
     * @description     : Load "Generate Holiday Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function holiday_pdf()
    {

        check_permission(ADD);

        if ($_GET && $this->input->get('date')) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $created_by = $this->input->get('created_by');

            $this->data['holidays'] = $this->attendance->get_holiday_list($form_date, $to_date, $created_by);
            $this->data['date'] = $date;
            $this->data['created_by'] = $created_by;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;

            $this->data['employee'] = $this->attendance->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/attendance/pdf/holiday', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('holiday_' . rand() . '.pdf', 'I');
        }
    }
}
