<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('stock'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bar-chart font-30 mr-10"></i>
                            <?php echo $this->lang->line('medicine'); ?> <?php echo $this->lang->line('detail'); ?>
                        </h6>
                    <?php } ?>
                    <div class="align-items-center">
                        <?php if (has_permission(VIEW, 'pharmacy', 'purchase')) { ?>
                            <a href="<?php echo site_url('pharmacy/purchase'); ?>" class="btn btn-xs btn-info">
                                <i class="fa fa-cart-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('purchase'); ?>
                            </a>
                        <?php } ?>
                        <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                            <a href="<?php echo site_url('pharmacy/refund'); ?>" class="btn btn-xs btn-success">
                                <i class="fa fa-undo font-12 mr-5"></i>
                                <?php echo $this->lang->line('refund'); ?>
                            </a>
                        <?php } ?>
                        <?php if (has_permission(VIEW, 'pharmacy', 'sale')) { ?>
                            <a href="<?php echo site_url('pharmacy/sale'); ?>" class="btn btn-xs btn-danger">
                                <i class="fa fa-balance-scale font-12 mr-5"></i>
                                <?php echo $this->lang->line('sale'); ?>
                            </a>
                        <?php } ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="media align-items-center">
                        <div class="media-img-wrap d-flex mr-10">
                            <div class="avatar avatar-sm">
                                <?php if ($medicine->photo) { ?>
                                    <img class="avatar-img rounded-circle" src="<?php echo UPLOAD_PATH; ?>medicine-photo/<?php echo $medicine->photo; ?>" alt="<?php echo $medicine->medicine_name; ?>" />
                                <?php } else { ?>
                                    <img class="avatar-img rounded-circle" src="<?php echo IMG_URL; ?>no-image.png" alt="no-image" />
                                <?php } ?>
                            </div>
                        </div>
                        <div class="media-body">
                            <div class="text-capitalize font-weight-500 text-dark"><?php echo $medicine->medicine_name; ?></div>
                            <div class="font-13"><?php echo $medicine->generic; ?></div>
                        </div>
                    </div>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item">
                            <span><i class="fa fa-industry font-18 text-light-20 mr-10"></i><span><?php echo $this->lang->line('manufacturer'); ?>:</span></span>
                            <span class="ml-5 text-dark"><?php echo $medicine->manufacturer; ?></span>
                        </li>
                        <li class="list-group-item">
                            <span><i class="fa fa-money font-18 text-light-20 mr-10"></i><span><?php echo $this->lang->line('purchase'); ?> <?php echo $this->lang->line('price'); ?>:</span></span>
                            <span class="ml-5 text-dark"><?php echo $this->global_setting->currency_symbol; ?> <?php echo $medicine->purchase_price; ?></span>
                        </li>
                        <li class="list-group-item">
                            <span><i class="fa fa-money font-18 text-light-20 mr-10"></i><span><?php echo $this->lang->line('sale'); ?> <?php echo $this->lang->line('price'); ?>:</span></span>
                            <span class="ml-5 text-dark"><?php echo $this->global_setting->currency_symbol; ?> <?php echo $medicine->sell_price; ?></span>
                        </li>
                        <li class="list-group-item">
                            <span><i class="fa fa-gift font-18 text-light-20 mr-10"></i><span><?php echo $this->lang->line('strength'); ?> :</span></span>
                            <span class="ml-5 text-dark"><?php echo $medicine->strength; ?></span>
                        </li>
                        <li class="list-group-item">
                            <span><i class="fa fa-gift font-18 text-light-20 mr-10"></i><span><?php echo $this->lang->line('unit'); ?> :</span></span>
                            <span class="ml-5 text-dark"><?php echo $medicine->unit; ?></span>
                        </li>
                    </ul>
                    <div class="row text-center">
                        <div class="col-4 border-right pr-0">
                            <div class="pa-15">
                                <span class="d-block display-6 text-dark mb-5"><?php echo number_format($total_purchase, 0) ?? 0; ?></span>
                                <span class="d-block text-capitalize font-14"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('purchase'); ?></span>
                            </div>
                        </div>
                        <div class="col-4 border-right px-0">
                            <div class="pa-15">
                                <span class="d-block display-6 text-dark mb-5"><?php echo number_format($total_sale, 0) ?? 0; ?></span>
                                <span class="d-block text-capitalize font-14"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('sale'); ?></span>
                            </div>
                        </div>
                        <div class="col-4 pl-0">
                            <div class="pa-15">
                                <span class="d-block display-6 text-dark mb-5"><?php echo number_format(($total_purchase ?? 0) - ($total_sale ?? 0), 0); ?></span>
                                <span class="d-block text-capitalize font-14"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('stock'); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bar-chart font-30 mr-10"></i>
                            <?php echo $this->lang->line('purchase'); ?> <?php echo $this->lang->line('report'); ?>
                        </h6>
                    <?php } ?>
                    <div class="form-inline">
                        <div class="form-group mr-10">
                            <input type="text" class="form-control form-control-sm" name="search_key" id="search_key" placeholder="<?php echo $this->lang->line('keyword'); ?>" />
                        </div>
                        <div class="form-group mr-10">
                            <div class="btn-toolbar" role="toolbar" aria-label="button groups">
                                <div class="btn-group mr-2" role="group" aria-label="First group">
                                    <button type="button" id="searchBtn" class="btn btn-sm btn-primary"><?php echo $this->lang->line('search'); ?></button>
                                    <button type="button" id="resetBtn" class="btn btn-sm btn-danger"><?php echo $this->lang->line('reset'); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div id="ajaxPurchaseData"></div>
                </div>
            </div>
        </div>


        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bar-chart font-30 mr-10"></i>
                            <?php echo $this->lang->line('sale'); ?> <?php echo $this->lang->line('report'); ?>
                        </h6>
                    <?php } ?>
                    <div class="form-inline">
                        <div class="form-group mr-10">
                            <input type="text" class="form-control form-control-sm" name="search_key" id="search_Salekey" placeholder="<?php echo $this->lang->line('keyword'); ?>" />
                        </div>
                        <div class="form-group mr-10">
                            <div class="btn-toolbar" role="toolbar" aria-label="button groups">
                                <div class="btn-group mr-2" role="group" aria-label="First group">
                                    <button type="button" id="searchSaleBtn" class="btn btn-sm btn-primary"><?php echo $this->lang->line('search'); ?></button>
                                    <button type="button" id="resetSaleBtn" class="btn btn-sm btn-danger"><?php echo $this->lang->line('reset'); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div id="ajaxSaleData"></div>
                </div>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<script>
    $(function() {
        /*--first time load--*/
        ajaxlist(page_url = false);

        /*-- Search keyword--*/
        $(document).on('click', "#searchBtn", function(event) {
            ajaxlist(page_url = false);
            event.preventDefault();
        });

        /*-- Reset Search--*/
        $(document).on('click', "#resetBtn", function(event) {
            $("#search_key").val('');
            ajaxlist(page_url = false);
            event.preventDefault();
        });

        /*-- Page click --*/
        $(document).on('click', ".pagination li a", function(event) {
            var page_url = $(this).attr('href');
            ajaxlist(page_url);
            event.preventDefault();
        });

        /*-- create function ajaxlist --*/
        function ajaxlist(page_url = false) {
            var search_key = $("#search_key").val();

            var dataString = 'search_key=' + search_key;
            var base_url = '<?php echo site_url('pharmacy/stock/ajaxPurchase/' . $this->uri->segment(4)) ?>';
            if (page_url == false) {
                var page_url = base_url;
            }
            $.ajax({
                type: "POST",
                url: page_url,
                data: dataString,
                success: function(response) {
                    $("#ajaxPurchaseData").html(response);
                }
            });
        }
    });
</script>


<script>
    $(function() {
        /*--first time load--*/
        ajaxlist(page_url = false);

        /*-- Search keyword--*/
        $(document).on('click', "#searchSaleBtn", function(event) {
            ajaxlist(page_url = false);
            event.preventDefault();
        });

        /*-- Reset Search--*/
        $(document).on('click', "#resetSaleBtn", function(event) {
            $("#search_Salekey").val('');
            ajaxlist(page_url = false);
            event.preventDefault();
        });

        /*-- Page click --*/
        $(document).on('click', ".pagination li a", function(event) {
            var page_url = $(this).attr('href');
            ajaxlist(page_url);
            event.preventDefault();
        });

        /*-- create function ajaxlist --*/
        function ajaxlist(page_url = false) {
            var search_key = $("#search_Salekey").val();

            var dataString = 'search_key=' + search_key;
            var base_url = '<?php echo site_url('pharmacy/stock/ajaxSale/' . $this->uri->segment(4)) ?>';
            if (page_url == false) {
                var page_url = base_url;
            }
            $.ajax({
                type: "POST",
                url: page_url,
                data: dataString,
                success: function(response) {
                    $("#ajaxSaleData").html(response);
                }
            });
        }
    });
</script>