<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('dosage'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_dosage'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('medicine/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'pharmacy', 'medicine')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-medkit font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('dosage'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('pharmacy/medicine/dosage'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('dosage'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('pharmacy/medicine/add_dosage'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="category_id"><?php echo $this->lang->line('category'); ?></label>
                            <select class="form-control select2" name="category_id" id="category_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($categories as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($category_id) && $category_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="category_id" class="form-text text-muted">
                                <?php echo form_error('category_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-8 mb-10">
                            <label for="name"><?php echo $this->lang->line('dosage'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('dosage'); ?> <?php echo $this->lang->line('name'); ?>">
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="short_name"><?php echo $this->lang->line('short_name'); ?></label>
                            <input type="text" class="form-control" name="short_name" id="short_name" value="<?php echo isset($short_name) ?  $short_name : ''; ?>" placeholder="<?php echo $this->lang->line('short_name'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="sort_by"><?php echo $this->lang->line('sort_by'); ?></label>
                            <input type="number" class="form-control" name="sort_by" id="sort_by" value="<?php echo isset($sort_by) ?  $sort_by : ''; ?>" placeholder="<?php echo $this->lang->line('sort_by'); ?>">
                        </div>
                        <div class="col-md-2 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" checked>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('note'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="note" aria-label="<?php echo $this->lang->line('note'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('pharmacy/medicine/dosage'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
</script>