<div class="table-wrap">
	<div class="table-responsive">
		<table class="table table-sm text-white">
			<tbody>
				<tr>
					<td><?php echo $this->lang->line('name'); ?></td>
					<td><?php echo $opd->patient_name; ?> [<?php echo $opd->patient_unique_id; ?>]</td>
					<td><?php echo $this->lang->line('phone'); ?></td>
					<td><?php echo $opd->phone; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('invoice_no'); ?></td>
					<td><?php echo $opd->custom_invoice_id; ?></td>
					<td><?php echo $this->lang->line('opd_no'); ?></td>
					<td><?php echo $opd->opd_no; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('date'); ?></td>
					<td><?php echo date($this->global_setting->date_format, strtotime($opd->appointment_date)); ?></td>
					<td><?php echo $this->lang->line('serial_no'); ?></td>
					<td><?php echo $opd->serial_no; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('doctor'); ?></td>
					<td><?php echo $opd->doctor; ?></td>
					<td><?php echo $this->lang->line('charge'); ?></td>
					<td><?php echo $opd->doctor_charge; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('discount'); ?></td>
					<td><?php echo $opd->discount; ?></td>
					<td><?php echo $this->lang->line('hospital'); ?> <?php echo $this->lang->line('commission'); ?></td>
					<td><?php echo $opd->hospital_commission; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('reference'); ?></td>
					<td><?php echo $opd->reference; ?></td>
					<td><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('status'); ?></td>
					<td>
						<?php
                                if ($opd->payment_status == 'rejected') {
                                    echo '<span class="badge badge-danger">' . $this->lang->line('rejected') . '</span>';
                                } elseif ($opd->payment_status == 'canceled') {
                                    echo '<span class="badge badge-warning">' . $this->lang->line('cancel') . '</span>';
                                } elseif ($opd->payment_status == 'pending') {
                                    echo '<span class="badge badge-info">' . $this->lang->line('pending') . '</span>';
                                } else {
                                    echo '<span class="badge badge-success">' . $this->lang->line('complete') . '</span>';
                                }
                                ?>
					</td>
				</tr>

				<tr>
					<td><?php echo $this->lang->line('height'); ?></td>
					<td><?php echo $opd->height; ?></td>
					<td><?php echo $this->lang->line('weight'); ?></td>
					<td><?php echo $opd->weight; ?></td>
				</tr>

				<tr>
					<td><?php echo $this->lang->line('bp'); ?></td>
					<td><?php echo $opd->bp; ?></td>
					<td><?php echo $this->lang->line('symptoms'); ?></td>
					<td><?php echo $opd->symptoms; ?></td>
				</tr>

				<tr>
					<td><?php echo $this->lang->line('casualty'); ?></td>
					<td><?php echo $opd->casualty ? $this->lang->line('yes') : $this->lang->line('no'); ?></td>
					<td><?php echo $this->lang->line('case'); ?></td>
					<td><?php echo $opd->case; ?></td>
				</tr>

				<tr>
					<td><?php echo $this->lang->line('remark'); ?></td>
					<td><?php echo $opd->note; ?></td>
					<td><?php echo $this->lang->line('old'); ?> <?php echo $this->lang->line('patient'); ?></td>
					<td><?php echo $opd->old_patient ? $this->lang->line('yes') : $this->lang->line('no'); ?></td>
				</tr>

				<?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
				<tr>
					<td><?php echo $this->lang->line('created_by'); ?></td>
					<td><?php echo $opd->created_by; ?></td>
					<td><?php echo $this->lang->line('created'); ?></td>
					<td><?php echo date('d F, Y h:i A', strtotime($opd->created_at)); ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('modified_by'); ?></td>
					<td><?php echo $opd->modified_by; ?></td>
					<td><?php echo $this->lang->line('modified'); ?></td>
					<td><?php echo $opd->modified_by ? date('d F, Y h:i A', strtotime($opd->modified_at)) : ''; ?>
					</td>
				</tr>
				<?php } else { ?>
				<tr>
					<td><?php echo $this->lang->line('created_by'); ?></td>
					<td><?php echo $opd->created_by; ?></td>
					<td><?php echo $this->lang->line('created'); ?></td>
					<td><?php echo date('d F, Y h:i A', strtotime($opd->created_at)); ?></td>
				</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
</div>