<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Type_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_type_list($limit, $offset, $keyword, $count) {
        $this->db->select('T.*');
        $this->db->from('leave_types AS T');
        if ($keyword) {
            $this->db->like('T.type', $keyword, 'both');
            $this->db->or_like('T.remark', $keyword, 'both');
        }
        $this->db->order_by('T.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_type($id) {
        $this->db->select('T.*, C.name as created_by, M.name as modified_by');
        $this->db->from('leave_types AS T');
        $this->db->join('employees AS C', 'C.user_id = T.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = T.modified_by', 'left');
        $this->db->where('T.id', $id);
        return $this->db->get()->row();
    }

    function duplicate_check($type, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('type', $type);
        return $this->db->get('leave_types')->num_rows();
    }
}
