<div class="table-wrap">
    <div class="table-responsive">
        <table class="table table-sm text-white">
            <tbody>
                <tr>
                    <td><?php echo $this->lang->line('patient'); ?></td>
                    <td>
                        <?php
                        if ($booking->patient_id) {
                            echo $booking->patient;
                        } else {
                            echo $booking->patient_name;
                        }
                        ?>
                    </td>
                    <td><?php echo $booking->patient_id ? $this->lang->line('phone') : $this->lang->line('address'); ?></td>
                    <td>
                        <?php
                        if ($booking->patient_id) {
                            echo $booking->phone;
                        } else {
                            echo $booking->address;
                        }
                        ?>
                    </td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('person'); ?></td>
                    <td>
                        <?php
                        if ($booking->booking_id) {
                            echo $booking->employee;
                        } else {
                            echo $booking->booking_name;
                        }
                        ?>
                    </td>
                    <td><?php echo $this->lang->line('phone'); ?></td>
                    <td>
                        <?php
                        if ($booking->booking_id) {
                            echo $booking->employee_phone;
                        } else {
                            echo $booking->phone;
                        }
                        ?>
                    </td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d/m/Y h:i A', strtotime($booking->date)); ?></td>
                    <td><?php echo $this->lang->line('status'); ?></td>
                    <td>
                        <?php if ($booking->is_active) { ?>
                            <span class="badge badge-success"><?php echo $this->lang->line('active'); ?></span>
                        <?php } else { ?>
                            <span class="badge badge-danger"><?php echo $this->lang->line('in_active'); ?></span>
                        <?php } ?>
                    </td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('group'); ?></td>
                    <td><?php echo $booking->bed_group; ?></td>
                    <td><?php echo $this->lang->line('floor'); ?></td>
                    <td><?php echo $booking->floor; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('type'); ?></td>
                    <td><?php echo $booking->bed_type; ?></td>
                    <td><?php echo $this->lang->line('bed'); ?></td>
                    <td><?php echo $booking->bed; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('remark'); ?></td>
                    <td colspan="3"><?php echo $booking->remark; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('created_by'); ?></td>
                    <td><?php echo $booking->created_by; ?></td>
                    <td><?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d F, Y h:i A', strtotime($booking->created_at)); ?></td>
                </tr>
                <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
                    <tr>
                        <td><?php echo $this->lang->line('modified_by'); ?></td>
                        <td><?php echo $booking->modified_by; ?></td>
                        <td><?php echo $this->lang->line('date'); ?></td>
                        <td><?php echo $booking->modified_by ? date('d F, Y h:i A', strtotime($booking->modified_at)) : ''; ?>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>