<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item"><?php echo $this->lang->line('ipd'); ?></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('booking'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_billing'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(ADD, 'ipd', 'booking')) { ?>
                <a href="<?php echo site_url('ipd/booking/add'); ?>" class="btn btn-success btn-sm"><i class="fa fa-plus"></i> <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('booking'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'ipd', 'booking')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bold font-30 mr-10"></i>
                            <?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    <?php echo form_open_multipart(site_url('ipd/booking'), array('name' => 'bill', 'id' => 'bill', 'class' => 'needs-validation form-inline', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group mr-2">
                        <div class="input-group input-group-sm">
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="button"><?php echo $this->lang->line('type'); ?></button>
                            </div>
                            <select class="form-control" name="type" id="type">
                                <option value="0" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('all'); ?></option>
                                <option value="1" <?php echo isset($type) && $type == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('yes'); ?></option>
                                <option value="2" <?php echo isset($type) && $type == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('no'); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('patient'); ?></th>
                                        <th><?php echo $this->lang->line('bed'); ?></th>
                                        <th><?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('person'); ?></th>
                                        <th><?php echo $this->lang->line('remark'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($bookings) && !empty($bookings)) { ?>
                                        <?php foreach ($bookings as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo date('d/m/Y h:i A', strtotime($obj->date)); ?></td>
                                                <td>
                                                    <?php
                                                    if ($obj->patient_id) {
                                                        echo $obj->patient . '<br>';
                                                        echo "<span class='font-weight-bold text-primary'>$obj->patient_unique_id</span>";
                                                    } else {
                                                        echo $obj->patient_name . '<br>';
                                                        echo "<span class='font-weight-bold text-primary'>$obj->address</span>";
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php echo $obj->bed_group; ?><br>
                                                    <?php echo $obj->floor; ?><br>
                                                    <?php echo $obj->bed_type; ?><br>
                                                    <span class="font-weight-bold text-primary"><?php echo $obj->bed; ?></span>
                                                </td>
                                                <td>
                                                    <?php
                                                    if ($obj->booking_id) {
                                                        echo $obj->employee . '<br>';
                                                        echo "<span class='font-weight-bold text-primary'>$obj->employee_phone</span>";
                                                    } else {
                                                        echo $obj->booking_name . '<br>';
                                                        echo "<span class='font-weight-bold text-primary'>$obj->phone</span>";
                                                    }
                                                    ?>
                                                </td>
                                                <td><?php echo $obj->remark; ?></td>
                                                <td>
                                                    <?php if ($obj->is_active == 1) { ?>
                                                        <span class="badge badge-success"><?php echo $this->lang->line('active'); ?></span>
                                                    <?php } else { ?>
                                                        <span class="badge badge-danger"><?php echo $this->lang->line('in_active'); ?></span>
                                                    <?php } ?>
                                                </td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'ipd', 'booking')) { ?>
                                                        <button class="btn btn-info btn-xs" type="button" onclick="get_view_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter"><i class="fa fa-eye"></i></button>
                                                    <?php } ?>
                                                    <?php if ($obj->is_active == 1) { ?>
                                                        <?php if (has_permission(EDIT, 'ipd', 'booking')) { ?>
                                                            <button onclick="getBookingData(<?php echo $obj->id; ?>)" type="button" class="btn btn-xs btn-success" data-toggle="modal" data-target="#editBookingModal"><i class="fa fa-edit"></i></button>
                                                        <?php } ?>
                                                        <?php if (has_permission(DELETE, 'ipd', 'booking')) { ?>
                                                            <a class="btn btn-xs btn-danger" href="<?php echo site_url('ipd/booking/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i> </a>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        <?php $sl_count++;
                                        } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="8"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<?php if (has_permission(EDIT, 'ipd', 'booking')) { ?>
    <!-- Edit Booking Modal -->
    <div class="modal fade" id="editBookingModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('booking'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form id="editBookingForm" method="POST" action="<?php echo base_url('ipd/booking/edit'); ?>">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="in_active"><?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('status'); ?></label>
                            <select class="form-control" name="in_active" id="in_active">
                                <option value="1"><?php echo $this->lang->line('active'); ?></option>
                                <option value="2"><?php echo $this->lang->line('in_active'); ?></option>
                            </select>
                        </div>
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                </div>
                                <textarea class="form-control" name="remark" id="remark" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($remark) ?  $remark : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <input type="hidden" id="booking_id" name="id">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button id="submit" type="submit" class="btn btn-primary"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        function getBookingData(id) {
            $('#booking_id').val(id);
        }
        $(document).ready(function(e) {
            $("#editBookingForm").on('submit', (function(e) {
                e.preventDefault();
                $('button[type=submit]').attr('disabled', true);
                $.ajax({
                    url: '<?php echo base_url('ipd/booking/edit'); ?>',
                    type: "POST",
                    data: new FormData(this),
                    dataType: 'json',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(data) {
                        if (data.status == "failed") {
                            var message = "";
                            $.each(data.error, function(index, value) {
                                message += value;
                            });
                            $.toast({
                                text: message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-danger',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });

                        } else {
                            $.toast({
                                text: data.message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-primary',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                            $('#editBookingModal').hide();
                        }
                    },
                    complete: function() {
                        window.location.replace('<?php echo base_url('ipd/booking'); ?>');
                    }
                });
            }));
        });
    </script>
<?php } ?>

<?php if (has_permission(VIEW, 'ipd', 'booking')) { ?>
    <div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header bg-gradient-primary">
                    <h5 class="modal-title text-white"><?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('info'); ?></h5>
                    <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body modal_data bg-gradient-secondary"></div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        function get_view_modal(id) {
            $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
            $.ajax({
                type: "POST",
                url: "<?php echo site_url('ipd/booking/get_single_booking'); ?>",
                data: {
                    id: id
                },
                success: function(response) {
                    if (response) {
                        $('.modal_data').html(response);
                    }
                }
            });
        }
    </script>
<?php } ?>