<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Payment_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_patient_payment_list($limit, $offset, $ipd_id, $search, $count) {
        $this->db->select('IP.*, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address');
        $this->db->from('ipd_advance_payments AS IP');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        if ($search) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search);
            $this->db->or_like('P.bn_name', $search);
            $this->db->or_like('P.gender', $search);
            $this->db->or_like('P.religion', $search);
            $this->db->or_like('P.blood_group', $search);
            $this->db->or_like('P.marital_status', $search);
            $this->db->or_like('P.address', $search);
            $this->db->or_like('IP.note', $search);
            $this->db->or_like('IP.payment_status', $search);
            $this->db->group_end();
        }
        $this->db->where('IP.ipd_id', $ipd_id);
        $this->db->order_by('IP.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_payment($id) {
        $this->db->select('IP.*, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, C.name as created_by, M.name as modified_by');
        $this->db->from('ipd_advance_payments AS IP');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = IP.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = IP.modified_by', 'left');
        $this->db->where('IP.id', $id);
        return $this->db->get()->row();
    }

    public function get_print_list($id) {
        $this->db->select('IP.*, D.name as doctor, D.specialist, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, C.name as created_by');
        $this->db->from('ipd_advance_payments AS IP');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        $this->db->join('ipd_patients AS I', 'I.id = IP.ipd_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.doctor_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = IP.created_by', 'left');
        $this->db->where('IP.id', $id);
        return $this->db->get()->row();
    }

    public function get_single_patient($patient_id) {
        $this->db->select('IP.*, D.name as doctor, D.specialist, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, C.name as created_by');
        $this->db->from('ipd_patients AS IP');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        $this->db->join('ipd_patients AS I', 'I.id = IP.ipd_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.doctor_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = IP.created_by', 'left');
        $this->db->where('IP.patient_id', $patient_id);
        return $this->db->get()->row();
    }
}
