<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Bed_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_patient_bed_list($limit, $offset, $ipd_id, $search, $count) {
        $this->db->select('IB.*, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, BG.name as ward_name, B.name as bed, B.price, F.name as floor');
        $this->db->from('ipd_beds AS IB');
        $this->db->join('patients AS P', 'P.user_id = IB.patient_id', 'left');
        $this->db->join('beds AS B', 'B.id = IB.bed_id', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = IB.bed_group_id', 'left');
        $this->db->join('floors AS F', 'F.id = BG.floor_id', 'left');
        if ($search) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search);
            $this->db->or_like('P.bn_name', $search);
            $this->db->or_like('P.gender', $search);
            $this->db->or_like('P.religion', $search);
            $this->db->or_like('P.blood_group', $search);
            $this->db->or_like('P.marital_status', $search);
            $this->db->or_like('P.address', $search);
            $this->db->or_like('B.name', $search);
            $this->db->or_like('BG.name', $search);
            $this->db->or_like('F.name', $search);
            $this->db->or_like('IB.note', $search);
            $this->db->group_end();
        }
        $this->db->where('IB.ipd_id', $ipd_id);
        $this->db->order_by('IB.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_bed($id) {
        $this->db->select('IB.*, D.name as doctor, D.specialist, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, BG.name as ward_name, B.name as bed, F.name as floor, C.name as created_by, M.name as modified_by');
        $this->db->from('ipd_beds AS IB');
        $this->db->join('patients AS P', 'P.user_id = IB.patient_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = IB.ipd_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = IP.doctor_id', 'left');
        $this->db->join('beds AS B', 'B.id = IB.bed_id', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = IB.bed_group_id', 'left');
        $this->db->join('floors AS F', 'F.id = BG.floor_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = IB.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = IB.modified_by', 'left');
        $this->db->where('IB.id', $id);
        return $this->db->get()->row();
    }
}
