<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('shift'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_shift'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('hrm/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'hrm', 'shift')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-tasks font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('shift'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'hrm', 'shift')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('hrm/shift'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('shift'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('hrm/shift/edit/' . $shift->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-5 mb-10">
                            <label for="name"><?php echo $this->lang->line('shift'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($shift->name) ?  $shift->name : ''; ?>" placeholder="<?php echo $this->lang->line('shift'); ?> <?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="bn_name"><?php echo $this->lang->line('shift'); ?> <?php echo $this->lang->line('bn_name'); ?></label>
                            <input type="text" class="form-control" name="bn_name" id="bn_name" value="<?php echo isset($shift->bn_name) ?  $shift->bn_name : ''; ?>" placeholder="<?php echo $this->lang->line('shift'); ?> <?php echo $this->lang->line('bn_name'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="weekend"><?php echo $this->lang->line('weekend'); ?></label>
                            <select class="form-control custom-select" name="weekend" id="weekend">
                                <?php $weekends = get_week_days(); ?>
                                <?php foreach ($weekends as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($shift->weekend) && $shift->weekend == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="in_time"><?php echo $this->lang->line('in_time'); ?></label>
                            <input type="text" class="form-control time" name="in_time" id="in_time" value="<?php echo isset($shift->in_time) ?  $shift->in_time : ''; ?>" placeholder="<?php echo $this->lang->line('in_time'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="in_time" class="form-text text-muted">
                                <?php echo form_error('in_time'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="out_time"><?php echo $this->lang->line('out_time'); ?></label>
                            <input type="text" class="form-control time" name="out_time" id="out_time" value="<?php echo isset($shift->out_time) ?  $shift->out_time : ''; ?>" placeholder="<?php echo $this->lang->line('out_time'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="out_time" class="form-text text-muted">
                                <?php echo form_error('out_time'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="late_time"><?php echo $this->lang->line('late_time'); ?></label>
                            <input type="text" class="form-control time" name="late_time" id="late_time" value="<?php echo isset($shift->late_time) ?  $shift->late_time : ''; ?>" placeholder="<?php echo $this->lang->line('late_time'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="late_time" class="form-text text-muted">
                                <?php echo form_error('late_time'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="absent_time"><?php echo $this->lang->line('absent_time'); ?></label>
                            <input type="text" class="form-control time" name="absent_time" id="absent_time" value="<?php echo isset($shift->absent_time) ?  $shift->absent_time : ''; ?>" placeholder="<?php echo $this->lang->line('absent_time'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="absent_time" class="form-text text-muted">
                                <?php echo form_error('absent_time'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="lunch_out_time"><?php echo $this->lang->line('lunch_out'); ?></label>
                            <input type="text" class="form-control time" name="lunch_out_time" id="lunch_out_time" value="<?php echo isset($shift->lunch_out_time) ?  $shift->lunch_out_time : ''; ?>" placeholder="<?php echo $this->lang->line('lunch_out'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="lunch_out_time" class="form-text text-muted">
                                <?php echo form_error('lunch_out_time'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="lunch_in_time"><?php echo $this->lang->line('lunch_in'); ?></label>
                            <input type="text" class="form-control time" name="lunch_in_time" id="lunch_in_time" value="<?php echo isset($shift->lunch_in_time) ?  $shift->lunch_in_time : ''; ?>" placeholder="<?php echo $this->lang->line('lunch_in'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="lunch_in_time" class="form-text text-muted">
                                <?php echo form_error('lunch_in_time'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mt-20">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="late_allow" id="late_allow" value="1" <?php echo $shift->late_allow ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="late_allow"><?php echo $this->lang->line('late_allow'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-3 mt-20">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="special_late_allow" id="special_late_allow" value="1" <?php echo $shift->special_late_allow ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="special_late_allow"><?php echo $this->lang->line('special'); ?> <?php echo $this->lang->line('late_allow'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-3 mt-20">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="early_out_allow" id="early_out_allow" value="1" <?php echo $shift->early_out_allow ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="early_out_allow"><?php echo $this->lang->line('early'); ?> <?php echo $this->lang->line('out_allow'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-2 mt-20">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="out_next_day" id="out_next_day" value="1" <?php echo $shift->out_next_day ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="out_next_day"><?php echo $this->lang->line('out_next_day'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-2 mt-20">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" <?php echo $shift->status ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                </div>
                                <textarea class="form-control" name="remark" id="remark" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($shift->remark) ?  $shift->remark : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $shift->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('hrm/shift'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Time Picker -->
<link href="<?php echo VENDOR_URL; ?>time/mdtimepicker.min.css" rel="stylesheet" type="text/css" />
<link href="<?php echo VENDOR_URL; ?>time/mdtimepicker-theme.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>time/mdtimepicker.min.js"></script>

<script>
    $('.time').mdtimepicker({
        timeFormat: 'hh:mm:ss.000',
        format: 'h:mm tt',
        // theme of the timepicker
        // 'red', 'purple', 'indigo', 'teal', 'green', 'dark'
        theme: 'teal',
        readOnly: false,
        hourPadding: false,
        clearBtn: false
    });
</script>