<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Shift_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_shift_list($limit, $offset, $keyword, $count) {
        $this->db->select('S.*');
        $this->db->from('shifts AS S');
        if ($keyword) {
            $this->db->like('S.name', $keyword, 'both');
            $this->db->or_like('S.bn_name', $keyword, 'both');
            $this->db->or_like('S.remark', $keyword, 'both');
        }
        $this->db->order_by('S.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_shift($id) {
        $this->db->select('S.*, C.name as created_by, M.name as modified_by');
        $this->db->from('shifts AS S');
        $this->db->join('employees AS C', 'C.user_id = S.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = S.modified_by', 'left');
        $this->db->where('S.id', $id);
        return $this->db->get()->row();
    }

    function duplicate_check($name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('shifts')->num_rows();
    }
}
