<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Ipd_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_charge_list($limit, $offset, $search, $count) {
        $this->db->select('IC.*');
        $this->db->from('charges AS IC');
        if ($search) {
            $this->db->like('IC.name', $search);
            $this->db->or_like('IC.bn_name', $search);
            $this->db->or_like('IC.note', $search);
        }
        $this->db->order_by('IC.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_charge_name($name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('charges')->num_rows();
    }

    function get_total_charge() {
        $this->db->select('IC.*, SUM(IC.price) as total_price');
        $this->db->from('charges AS IC');
        $this->db->where('IC.status', 1);
        return $this->db->get()->row();
    }

    function get_total_package_price() {
        $this->db->select('PI.*, SUM(PI.price) as total_price');
        $this->db->from('package_items AS PI');
        $this->db->where('PI.status', 1);
        return $this->db->get()->row();
    }

    public function get_package_list($limit, $offset, $search, $count) {
        $this->db->select('IP.*');
        $this->db->from('ipd_packages AS IP');
        if ($search) {
            $this->db->like('IP.name', $search);
            $this->db->or_like('IP.bn_name', $search);
        }
        $this->db->order_by('IP.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function get_charge_items() {
        $this->db->select('IC.*');
        $this->db->from('charges AS IC');
        $this->db->where('IC.status', 1);
        return $this->db->get()->result();
    }
}
