<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Category_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_category_list($limit, $offset, $keyword, $count) {
        $this->db->select('G.*,');
        $this->db->from('galleries AS G');
        if ($keyword) {
            $this->db->like('G.title', $keyword, 'both');
            $this->db->or_like('G.bn_title', $keyword, 'both');
            $this->db->or_like('G.description', $keyword, 'both');
            $this->db->or_like('G.bn_description', $keyword, 'both');
        }
        $this->db->order_by('G.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_category($id) {
        $this->db->select('G.*, C.name as created_by, M.name as modified_by');
        $this->db->from('galleries AS G');
        $this->db->join('employees AS C', 'C.user_id = G.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = G.modified_by', 'left');
        $this->db->where('G.id', $id);
        return $this->db->get()->row();
    }

    function duplicate_check($title, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('title', $title);
        return $this->db->get('galleries')->num_rows();
    }
}
