<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class History_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_appointment_history_list($limit, $offset, $keyword, $form_date, $to_date, $created_by, $count = 0)
    {
        $this->db->select('AH.*, C.name as created_by');
        $this->db->from('appointment_histories AS AH');
        $this->db->join('employees AS C', 'C.user_id = AH.created_by', 'left');
        if ($keyword) {
            $this->db->group_start();
            $this->db->like('AH.id', $keyword, 'both');
            $this->db->or_like('AH.old_data', $keyword, 'both');
            $this->db->or_like('AH.new_data', $keyword, 'both');
            $this->db->group_end();
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(AH.created_at) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($created_by) {
            $this->db->where('AH.created_by', $created_by);
        }
        $this->db->order_by('AH.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_appointment_history($id)
    {
        $this->db->select('AH.*, C.name as created_by, M.name as modified_by');
        $this->db->from('appointment_histories AS AH');
        $this->db->join('employees AS C', 'C.user_id = AH.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = AH.modified_by', 'left');
        $this->db->where('AH.id', $id);
        return $this->db->get()->row();
    }
}
